package io.gitee.declear.dec.cloud.common.constants;

/**
 * 常量
 * @author DEC
 */
public interface Constants {

    // netty constants start
    /**
     * enable netty epoll.
     */
    String NETTY_EPOLL_ENABLE_KEY = "netty.epoll.enable";

    /**
     * 获取操作系统名称
     */
    String OS_NAME_KEY = "os.name";

    /**
     * linux操作系统
     */
    String OS_LINUX_PREFIX = "linux";

    /**
     * 默认的netty io 线程数
     */
    int DEFAULT_IO_THREADS = Math.min(Runtime.getRuntime().availableProcessors() + 1, 32);

    /**
     * netty netty_server_boss 线程池名称
     */
    String EVENT_LOOP_SERVER_BOSS_POOL_NAME = "netty_server_boss";

    /**
     * netty netty_server_worker 线程池名称
     */
    String EVENT_LOOP_SERVER_WORKER_POOL_NAME = "netty_server_worker";

    /**
     * netty netty_client_worker 线程池名称
     */
    String EVENT_LOOP_CLIENT_WORKER_POOL_NAME = "netty_client_worker";

    /**
     * netty enable netty epoll 默认false
     */
    String NETTY_EPOLL_ENABLE_DEFAULT_VALUE = "false";

    /**
     * netty channel链接无使用默认中断时间
     */
    int NETTY_CHANNEL_IDLE_TIMEOUT_DEFAULT_VALUE = 60 * 1000;

    /**
     * netty server 默认关闭动作时间
     */
    int NETTY_SERVER_DEFAULT_SHUTDOWN_TIMEOUT = 10000;

    /**
     * netty client 默认链接等待时间
     */
    int NETTY_CLIENT_DEFAULT_CONNECT_TIMEOUT = 3000;

    /**
     * netty client 默认关闭动作时间
     */
    int NETTY_CLIENT_DEFAULT_SHUTDOWN_TIMEOUT = 10000;

    /**
     * netty client 默认心跳包发送间隔
     */
    int NETTY_CLIENT_DEFAULT_HEARTBEAT = 60 * 1000;

    /**
     * dec-cloud.yml 中自定义channel链接无使用默认中断时间
     */
    String DEC_CLOUD_NETTY_CHANNEL_IDLE_TIMEOUT_KEY = "dec.cloud.netty.channel.idle.timeout";

    /**
     * dec-cloud.yml 中自定义client.socks5代理地址
     */
    String DEC_CLOUD_NETTY_CLIENT_SOCKS_PROXY_HOST_KEY = "dec.cloud.netty.client.socks5.proxy.host";

    /**
     * dec-cloud.yml 中自定义client.socks5代理端口
     */
    String DEC_CLOUD_NETTY_CLIENT_SOCKS_PROXY_PORT_KEY = "dec.cloud.netty.client.socks5.proxy.port";

    /**
     * dec-cloud https ssl enabled
     */
    String DEC_CLOUD_NETTY_SSL_ENABLED_KEY = "dec.cloud.netty.ssl-enabled";

    /**
     * dec-cloud https ssl config: server-key-cert-chain-path
     */
    String DEC_CLOUD_NETTY_SSL_SERVER_KEY_CERT_CHAIN_PATH = "dec.cloud.netty.server-key-cert-chain-path";

    /**
     * dec-cloud https ssl config: server-private-key-path
     */
    String DEC_CLOUD_NETTY_SSL_SERVER_PRIVATE_KEY_PATH = "dec.cloud.netty.server-private-key-path";

    /**
     * dec-cloud https ssl config: server-trust-cert-collection-path
     */
    String DEC_CLOUD_NETTY_SSL_SERVER_TRUST_CERT_COLLECTION_PATH = "dec.cloud.netty.server-trust-cert-collection-path";

    /**
     * dec-cloud https ssl config: server-key-password
     */
    String DEC_CLOUD_NETTY_SSL_SERVER_KEY_PASSWORD = "dec.cloud.netty.server-key-password";

    /**
     * dec-cloud https ssl config: client-key-cert-chain-path
     */
    String DEC_CLOUD_NETTY_SSL_CLIENT_KEY_CERT_CHAIN_PATH = "dec.cloud.netty.client-key-cert-chain-path";

    /**
     * dec-cloud https ssl config: client-private-key-path
     */
    String DEC_CLOUD_NETTY_SSL_CLIENT_PRIVATE_KEY_PATH = "dec.cloud.netty.client-private-key-path";

    /**
     * dec-cloud https ssl config: client-trust-cert-collection-path
     */
    String DEC_CLOUD_NETTY_SSL_CLIENT_TRUST_CERT_COLLECTION_PATH = "dec.cloud.netty.client-trust-cert-collection-path";

    /**
     * dec-cloud https ssl config: client-key-password
     */
    String DEC_CLOUD_NETTY_SSL_CLIENT_KEY_PASSWORD = "dec.cloud.netty.client-key-password";
    // netty constants end

    // dec-cloud constants start
    /**
     * dec-cloud配置文件名
     */
    String DEC_CLOUD_YML_FILE = "dec-cloud.yml";

    /**
     * dec-cloud 当前服务类型 index/service/gateway
     */
    String DEC_CLOUD_TYPE = "dec.cloud.type";

    /**
     * dec-cloud 当前服务类型 index
     */
    String DEC_CLOUD_TYPE_INDEX = "index";

    /**
     * dec-cloud 当前服务类型 service
     */
    String DEC_CLOUD_TYPE_SERVICE = "service";

    /**
     * dec-cloud 当前服务类型 gateway
     */
    String DEC_CLOUD_TYPE_GATEWAY = "gateway";

    /**
     * dec-cloud 当前服务实例名
     */
    String DEC_CLOUD_INSTANCE_NAME = "dec.cloud.instance";

    /**
     * dec-cloud 当前服务实例名
     */
    String DEC_CLOUD_CONTEXT_PATH = "dec.cloud.context-path";

    /**
     * dec-cloud 当前服务实例端口
     */
    String DEC_CLOUD_PORT = "dec.cloud.port";

    /**
     * dec-cloud 当前实例服务注册的index地址 对 service/gateway 有效
     */
    String DEC_CLOUD_INDEX_URL = "dec.cloud.index.url";

    /**
     * prefix for loading from the class path: "classpath:".
     */
    String DEC_CLOUD_CLASSPATH_URL_PREFIX = "classpath:";
    // dec-cloud constants end

    // dec-cloud protocol code constants start
    /**
     * dec-cloud 服务间数据传输协议名称: DECP
     */
    String DEC_CLOUD_CODE_PROTOCOL_NAME = "DECP";

    /**
     * dec-cloud 服务间数据传输协议DECP名称字符长度
     */
    int DEC_CLOUD_CODE_PROTOCOL_NAME_LENGTH = 4;

    /**
     * dec-cloud 服务间数据传输协议类型: send invoke data
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_1 = 1;

    /**
     * dec-cloud 服务间数据传输协议类型: send result back
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_2 = 2;

    /**
     * dec-cloud 服务间数据传输协议类型: send file
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_3 = 3;

    /**
     * dec-cloud 服务间数据传输协议类型: 服务注册
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_4 = 4;

    /**
     * dec-cloud 服务间数据传输协议类型: 服务注册结果，返回
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_5 = 5;

    /**
     * dec-cloud 服务间数据传输协议类型: 服务发送对外发布接口
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_6 = 6;

    /**
     * dec-cloud 服务间数据传输协议类型: 服务发送对外发布接口结果，返回
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_7 = 7;

    /**
     * dec-cloud 服务间数据传输协议类型: 服务发送对外发布接口完毕
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_8 = 8;

    /**
     * dec-cloud 服务间数据传输协议类型: 服务发送对外发布接口结果完毕,确认
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_9 = 9;

    /**
     * dec-cloud 服务间分享服务资源列表信息
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_10 = 10;

    /**
     * dec-cloud 服务间分享服务资源列表信息的回复
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_11 = 11;

    /**
     * dec-cloud service/gateway 向 index 报告错误信息
     */
    short DEC_CLOUD_CODE_PROTOCOL_TYPE_12 = 12;

    /**
     * dec-cloud 服务间数据传输协议版本1.0.0
     */
    String DEC_CLOUD_CODE_PROTOCOL_VERSION_1_0_0 = "1.0.0";

    /**
     * dec-cloud 服务间数据传输协议版本
     */
    String DEC_CLOUD_CODE_PROTOCOL_VERSION = DEC_CLOUD_CODE_PROTOCOL_VERSION_1_0_0;

    /**
     * dec-cloud 服务间数据传输协议版本字符长度
     */
    int DEC_CLOUD_CODE_PROTOCOL_VERSION_LENGTH = 5;

    /**
     * dec-cloud 服务间数据包ID字符长度
     */
    int DEC_CLOUD_CODE_PROTOCOL_PACK_ID_LENGTH = 32;
    // dec-cloud protocol code constants end

    // dec-cloud web constants start
    /**
     * dec-cloud web服务报错时的返回信息
     */
    String DEC_CLOUD_WEB_SERVER_INTERNAL_ERROR = "Web Server Internal Error.";

    /**
     * dec-cloud web服务设置cookie
     */
    String DEC_CLOUD_WEB_SERVER_SET_COOKIE = "Set-Cookie";

    /**
     * dec-cloud web服务cookie名字 cookie in header.
     */
    String DEC_CLOUD_WEB_SERVER_COOKIE = "Cookie";

    /**
     * dec-cloud web服务设置cookie
     */
    String DEC_CLOUD_WEB_SERVER_SESSION_ID = "DEC_SESSION_ID";

    /**
     * dec-cloud web服务设置cookie
     */
    long DEC_CLOUD_WEB_SERVER_SESSION_EXPIRE_TIME_MINUTES = 30L;

    /**
     * dec-cloud uri分隔符
     */
    char DEC_CLOUD_HTTP_URI_SPLIT_CHARACTER = '/';
    // dec-cloud web constants end
}
