package io.gitee.declear.dec.cloud.common.mono;

import io.gitee.declear.dec.cloud.common.remoting.DecPromise;
import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext;
import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContextHolder;

import java.io.Serializable;

/**
 * dec cloud 响应式 mono
 * @author DEC
 */
public class DecCloudContextMono<T extends Serializable> {

    private DecRemoteContext<T> context;

    private DecCloudContextMono(T object) {
        context = (DecRemoteContext<T>) DecRemoteContextHolder.getRemoteContext();
    }

    public static <T extends Serializable> DecCloudContextMono<T> execute(T t) {
        return new DecCloudContextMono<>(t);
    }

    public DecCloudContextMono<T> onSuccess(DecPromise<T> promise) {
        context.setOnSuccess(promise);
        return this;
    }

    public DecCloudContextMono<T> onFailure(DecPromise<Throwable> promise) {
        context.setOnFailure(promise);
        return this;
    }

    public DecCloudContextMono<T> onComplete(DecPromise<T> promise) {
        context.onComplete((DecPromise<Serializable>) promise);
        return this;
    }
}
