package io.gitee.declear.dec.cloud.common.property;

import io.gitee.declear.common.utils.CommonUtils;
import io.gitee.declear.dec.cloud.common.constants.Constants;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 配置属性管理器
 * @author DEC
 */
public class PropertiesManager {

    private transient volatile ConcurrentHashMap<String, String> properties;

    public PropertiesManager(Map<String, String> properties) {
        if(this.properties == null) {
            this.properties = new ConcurrentHashMap<>();
        }
        addProperties(properties);
    }

    public void init() {

    }

    public void shutdown() {

    }

    public String getProperty(String key) {
        return getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        return properties.containsKey(key) ? properties.get(key) : defaultValue;
    }

    public InputStream getFilePropertyInputStream(String key) throws IOException {
        InputStream inputStream = null;
        if (getProperty(key) != null) {
            inputStream = getUrl(key).openStream();
        }
        return inputStream;
    }

    private URL getUrl(String resourceLocation) throws FileNotFoundException {
        try {
            if (CommonUtils.isEmpty(resourceLocation)) {
                throw new IllegalArgumentException("Resource location must not be null");
            }
            if (resourceLocation.startsWith(Constants.DEC_CLOUD_CLASSPATH_URL_PREFIX)) {
                String path = resourceLocation.substring(Constants.DEC_CLOUD_CLASSPATH_URL_PREFIX.length());
                ClassLoader cl = getClass().getClassLoader();
                URL url = (cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path));
                if (url == null) {
                    String description = "class path resource [" + path + "]";
                    throw new FileNotFoundException(description +
                            " cannot be resolved to URL because it does not exist");
                }
                return url;
            }
            // try URL
            return new URL(resourceLocation);
        } catch (MalformedURLException ex) {
            // no URL -> treat as file path
            try {
                return new File(resourceLocation).toURI().toURL();
            } catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation +
                        "] is neither a URL not a well-formed file path");
            }
        }
    }

    public void addProperties(Map<String, String> properties) {
        if(CommonUtils.isNotEmpty(properties)) {
            properties.forEach((key, value) -> {
                this.properties.put(key, value);
            });
        }

    }
}
