package io.gitee.declear.dec.cloud.common.remoting;

import io.gitee.declear.dec.cloud.common.constants.Constants;
import io.gitee.declear.dec.cloud.common.remoting.resource.DecCloudApi;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * dec cloud 远程调用context
 * @author DEC
 */
@Data
public class DecRemoteContext<T extends Serializable> {

    @Serial
    private static final long serialVersionUID = 964147919028603726L;

    public static final Short REMOTE_CONTEXT_COMPLETE_STATUS_PENDING = 0;
    public static final Short REMOTE_CONTEXT_COMPLETE_STATUS_COMPLETE = 3;

    public static final Short REMOTE_CONTEXT_BACK_STATUS_SUCCESS = 1;
    public static final Short REMOTE_CONTEXT_BACK_STATUS_FAILURE = 2;

    /**
     * uuid context编号
     */
    private String id;

    /**
     * 类型： 发送调用信息或者返回结果 发送文件
     * DEC_CLOUD_CODE_PROTOCOL_TYPE
     */
    private Short type;

    /**
     * 调用的远程接口
     */
    private DecCloudApi cloudDestination;

    /**
     * 调用的远程接口
     */
    private DecCloudApi cloudOrigin;

    /**
     * 远程调用参数列表
     */
    private List<Serializable> paramList;

    /**
     * 远程调用报错信息
     */
    private Throwable failure;

    /**
     * 远程调用完成之后返回的结果
     */
    private T result;

    /**
     * 远程调用完成之后返回的处理状态 0 成功则result取值， 1 失败则failure取值
     */
    private Short backStatus;

    /**
     * 完成状态,
     */
    private Short completeStatus = REMOTE_CONTEXT_COMPLETE_STATUS_PENDING;

    /**
     * 数据重发次数
     */
    private Integer retryTimes;

    private DecPromise<T> onSuccess;

    private DecPromise<Throwable> onFailure;

    private List<DecPromise<Serializable>> onComplete = new ArrayList<>();

    public void onComplete(DecPromise<Serializable> promise) {
        if(Objects.equals(completeStatus, REMOTE_CONTEXT_COMPLETE_STATUS_COMPLETE)) {
            if(Objects.equals(backStatus, REMOTE_CONTEXT_BACK_STATUS_SUCCESS)) {
                promise.exec(result);
            } else {
                promise.exec(Constants.DEC_CLOUD_WEB_SERVER_INTERNAL_ERROR);
            }
        } else {
            onComplete.add(promise);
        }
    }
}
