package io.gitee.declear.dec.cloud.common.remoting;

import org.springframework.core.NamedThreadLocal;

import java.io.Serializable;

/**
 * DecRemoteContext threadLocal holder
 * @author DEC
 */
public class DecRemoteContextHolder {

    private static final ThreadLocal<DecRemoteContext<Serializable>> REMOTE_CONTEXT_THREAD_LOCAL = new NamedThreadLocal<>("remote-context");

    public static void setRemoteContext(DecRemoteContext<Serializable> context) {
        REMOTE_CONTEXT_THREAD_LOCAL.remove();
        REMOTE_CONTEXT_THREAD_LOCAL.set(context);
    }

    public static DecRemoteContext<Serializable> getRemoteContext() {
        return REMOTE_CONTEXT_THREAD_LOCAL.get();
    }

    public static void removeRemoteContext() {
        REMOTE_CONTEXT_THREAD_LOCAL.remove();
    }
}
