package io.gitee.declear.dec.cloud.common.remoting.resource;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.net.InetSocketAddress;

/**
 * dec cloud 接口定义
 * @author DEC
 */
@Data
public class DecCloudApi implements Serializable {

    @Serial
    private static final long serialVersionUID = 901626471284303814L;

    private static final char PARAMETER_TYPES_SEPARATE_CHAR = ',';

    private InetSocketAddress address;

    private String instance;

    private Class<?> beanClass;

    private String interfaceMethod;

    private Class<?>[] parameterTypes;

    public String generateIdWithInstance() {
        return String.format("%s:%d/%s", address.getAddress().getHostAddress(), address.getPort(), instance);
    }

    public String generateIdWithAddress() {
        return generateIdWithParameterTypes(String.format("%s:%d/%s/%s#%s", address.getAddress().getHostAddress(),
                address.getPort(), instance, beanClass.getName(), interfaceMethod));
    }

    public String generateIdWithInstanceAndMethod() {
        return generateIdWithParameterTypes(String.format("%s#%s", instance, interfaceMethod));
    }

    public String generateIdWithClass() {
        return generateIdWithParameterTypes(String.format("%s/%s#%s", instance, beanClass.getName(), interfaceMethod));
    }

    private String generateIdWithParameterTypes(String id) {
        StringBuilder builder = new StringBuilder(id);
        if(parameterTypes != null && parameterTypes.length > 0) {
            builder.append("(");
            for (Class<?> parameterType : parameterTypes) {
                builder.append(parameterType.getName()).append(PARAMETER_TYPES_SEPARATE_CHAR);
            }
            if(builder.charAt(builder.length() - 1) == PARAMETER_TYPES_SEPARATE_CHAR) {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append(")");
        }

        return builder.toString();
    }

}
