package io.gitee.declear.dec.cloud.common.remoting.resource;

import io.gitee.declear.common.utils.CommonUtils;
import lombok.Data;
import org.springframework.util.DigestUtils;

import java.io.*;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Dec cloud框架相关的资源,
 * @author DEC
 */
@Data
public class DecCloudResource implements Serializable {

    @Serial
    private static final long serialVersionUID = -642258114275188300L;

    /**
     * 服务ip地址和端口
     */
    private InetSocketAddress address;

    /**
     * 服务实例类型，见 io.gitee.declear.dec.cloud.common.constants.Constants.DEC_CLOUD_TYPE
     */
    private String type;

    /**
     * 服务实例名
     */
    private String instance;

    /**
     * 当前服务发布的远程调用接口
     */
    private Map<String, DecCloudApi> decCloudApiMap;

    /**
     * 当前服务是否激活
     */
    private Boolean isActive;

    /**
     * 当前服务是否远程调用接口发布完毕
     */
    private Boolean isApiComplete;

    public String generateId() {
        return String.format("%s:%d/%s", address.getAddress().getHostAddress(), address.getPort(), instance);
    }

    public String generateIdApiMd5() throws IOException {
        if(CommonUtils.isNotEmpty(decCloudApiMap)) {
            List<String> apiIdList =new ArrayList<>();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            decCloudApiMap.forEach((key, value) -> {
                apiIdList.add(key);
            });
            Collections.sort(apiIdList);
            for(String apiId : apiIdList) {
                oos.writeObject(apiId);
            }

            return DigestUtils.md5DigestAsHex(bos.toByteArray());
        }
        return null;
    }

}
