package io.gitee.declear.dec.cloud.common.rpc.netty;

import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * Netty Client 最后一层数据处理器
 * @author DEC
 */
@Slf4j
public class NettyClientHandler extends ChannelDuplexHandler {

    @Setter
    private NettyClient nettyClient;

    public NettyClientHandler(NettyClient nettyClient) {
        setNettyClient(nettyClient);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        // server will close channel when server don't receive any heartbeat from client util timeout.
        if (evt instanceof IdleStateEvent) {
            try {
                ctx.channel().close();
                log.info("IdleStateEvent triggered, close channel: {}", ctx.channel());
            } finally {

            }
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("connected to server {}.", ctx.channel().remoteAddress());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {

    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if(msg instanceof DecRemoteContext) {
            nettyClient.receiveRemoteContext((DecRemoteContext) msg);
        }
        ctx.fireChannelRead(msg);
    }

}
