package io.gitee.declear.dec.cloud.common.rpc.netty;

import io.netty.channel.Channel;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * netty 全局属性管理器
 * @author DEC
 */
@Slf4j
public class NettyGlobalResourceManager {

    @Setter
    private NettyServer nettyServer;

    private Map<InetSocketAddress, Channel> serverChannelMap = null;

    @Setter
    private NettyClient nettyClient;

    private Map<InetSocketAddress, Channel> clientChannelMap = null;

    public void init() {
        serverChannelMap = new ConcurrentHashMap<>(200);
        clientChannelMap = new ConcurrentHashMap<>(200);
    }

    public void shutdown() {

    }

    public void addServerChannel(InetSocketAddress address, Channel channel) {
        serverChannelMap.put(address, channel);
    }

    public Channel getServerChannel(InetSocketAddress address) {
        return serverChannelMap.get(address);
    }

    public void removeServerChannel(InetSocketAddress address) {
        serverChannelMap.remove(address);
    }

    public void addClientChannel(InetSocketAddress address, Channel channel) {
        clientChannelMap.put(address, channel);
    }

    public Channel getClientChannel(InetSocketAddress address) throws InterruptedException {
        if(null == clientChannelMap.get(address) || !clientChannelMap.get(address).isOpen()) {
            return nettyClient.connect(address);
        }
        return clientChannelMap.get(address);
    }

    public void removeClientChannel(InetSocketAddress address) {
        clientChannelMap.remove(address);
    }

}
