package io.gitee.declear.dec.cloud.common.rpc.netty;

import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext;
import io.gitee.declear.dec.cloud.common.web.DecHttpAttributeBuilder;
import io.gitee.declear.dec.cloud.common.web.context.DecWebContext;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.timeout.IdleStateEvent;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;

/**
 * netty server 接收到的数据处理分发
 * @author DEC
 */
@Slf4j
public class NettyServerHandler extends ChannelDuplexHandler {

    @Setter
    private NettyServer nettyServer;

    public NettyServerHandler(NettyServer nettyServer) {
        setNettyServer(nettyServer);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        // server will close channel when server don't receive any heartbeat from client util timeout.
        if (evt instanceof IdleStateEvent) {
            try {
                ctx.channel().close();
                log.info("IdleStateEvent triggered, close channel: {}", ctx.channel());
            } finally {

            }
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("client {} connected.", ctx.channel().remoteAddress());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {

    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if(msg instanceof DecRemoteContext) {
            nettyServer.receiveRemoteContext((DecRemoteContext) msg);
        } else if(msg instanceof FullHttpRequest){
            DecWebContext context = new DecWebContext();
            try {
                context.setHttpRequest(DecHttpAttributeBuilder.buildHttpRequest((FullHttpRequest)msg));
                context.setHttpSession(DecHttpAttributeBuilder.searchSession(context.getHttpRequest()));
                context.setChannelHandlerContext(ctx);
                context.setReceiveTime(LocalDateTime.now());
                nettyServer.receiveWebContext(context);
            } catch (Exception e) {
                log.error("process DecWebContext error.", e);
            }
        } else {
            log.error("NettyServerHandler not support msg type: {}", msg.getClass());
        }
    }
}
