package io.gitee.declear.dec.cloud.common.rpc.protocol;

import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext;
import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContextHolder;
import io.gitee.declear.dec.cloud.common.rpc.netty.NettyGlobalResourceManager;
import io.gitee.declear.dec.cloud.common.rpc.protocol.pack.DecCloudProtocolPack;
import io.netty.channel.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.File;
import java.io.Serializable;

/**
 * netty 发送/接收数据的协议实现
 * @author DEC
 */
@Slf4j
public class DecCloudProtocol implements Protocol {

    @Autowired
    private NettyGlobalResourceManager nettyGlobalResourceManager;

    @Override
    public void sendData(DecRemoteContext<Serializable> context, DecCloudProtocolPack pack) throws InterruptedException {
        // 通过context确定Channel
        Channel channel = nettyGlobalResourceManager.getClientChannel(context.getCloudDestination().getAddress());
        channel.writeAndFlush(pack);
        DecRemoteContextHolder.removeRemoteContext();
    }

    @Override
    public void sendFile(DecRemoteContext<Serializable> context, File file) throws InterruptedException {
        // 通过context确定Channel
        Channel channel = nettyGlobalResourceManager.getClientChannel(context.getCloudDestination().getAddress());
        channel.writeAndFlush(file);
    }

    @Override
    public void sendResult(DecRemoteContext<Serializable> context, DecCloudProtocolPack pack) throws InterruptedException {
        // 通过context确定Channel
        Channel channel = nettyGlobalResourceManager.getClientChannel(context.getCloudOrigin().getAddress());
        channel.writeAndFlush(pack);
    }

}
