package io.gitee.declear.dec.cloud.common.rpc.protocol;

import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext;
import io.gitee.declear.dec.cloud.common.rpc.protocol.pack.DecCloudProtocolPack;

import java.io.File;
import java.io.Serializable;

/**
 * netty 发送/接收数据的协议
 * @author DEC
 */
public interface Protocol {

    /**
     * 发送数据
     * @param context
     * @param pack
     * @throws InterruptedException
     */
    void sendData(DecRemoteContext<Serializable> context, DecCloudProtocolPack pack) throws InterruptedException;

    /**
     * 发送文件
     * @param context
     * @param file
     * @throws InterruptedException
     */
    void sendFile(DecRemoteContext<Serializable> context, File file) throws InterruptedException;

    /**
     * 返回结果
     * @param context
     * @param pack
     * @throws InterruptedException
     */
    void sendResult(DecRemoteContext<Serializable> context, DecCloudProtocolPack pack) throws InterruptedException;

}
