package io.gitee.declear.dec.cloud.common.rpc.protocol.code;

import io.gitee.declear.dec.cloud.common.web.DecHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.*;
import lombok.extern.slf4j.Slf4j;

import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * netty 编码/解码器: dec-cloud协议编解码器
 * @author DEC
 */
@Slf4j
public class DecCloudHttpCodeAdapter {

    private final ChannelOutboundHandlerAdapter decCloudHttpEncoder = new DecCloudHttpCodeAdapter.InternalEncoder();

    public ChannelOutboundHandlerAdapter getEncoder() {
        return decCloudHttpEncoder;
    }

    private class InternalEncoder extends MessageToMessageEncoder<DecHttpResponse> {

        @Override
        protected void encode(ChannelHandlerContext ctx, DecHttpResponse msg, List<Object> out) throws Exception {

            FullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.valueOf(msg.version().name()), HttpResponseStatus.valueOf(msg.status().code()));
            Iterator<Map.Entry<String, String>> iterator = msg.header().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                response.headers().set(entry.getKey(), entry.getValue());
            }
            ByteBuf buffer = Unpooled.copiedBuffer(msg.content(), StandardCharsets.UTF_8);
            response.content().writeBytes(buffer);
            buffer.release();

            out.add(response);
        }
    }

}
