package io.gitee.declear.dec.cloud.common.rpc.protocol.pack;

import io.gitee.declear.dec.cloud.common.remoting.resource.DecCloudApi;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * DEC远程调用协议数据包
 * @author DEC
 */
@Data
public class DecCloudProtocolPack {

    /**
     * 发送数据格式
     * type/short  +  version/byte[5]  +  id/byte[32]
     * is_origin_data/short(0不存在, 1存在) + (1存在)(origin_length/int + origin_data[origin_length])
     * is_destination_data/short(0不存在, 1存在) + (1存在)(destination_length/int + destination_data[destination_length])
     * dataList.size()/int
     * data1.length/int + data2.length/int + data3.length/int + ......(num = dataList.size())
     * data1/byte[data1.length] + data2/byte[data2.length] + data2/byte[data2.length] + ......(num = dataList.size())
     */

    /**
     * uuid
     */
    private String id;

    /**
     * DEC_CLOUD_CODE_PROTOCOL_TYPE
     * 同 io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext.type
     */
    private Short type;

    /**
     * DEC_CLOUD_CODE_PROTOCOL_VERSION
     * 发送数据格式版本
     */
    private String version;

    /**
     * 调用的远程接口
     */
    private DecCloudApi cloudDestination;

    /**
     * 调用的远程接口
     */
    private DecCloudApi cloudOrigin;

    /**
     * 数据包内数据列表
     */
    private List<Serializable> dataList;

}
