package io.gitee.declear.dec.cloud.common.web;

import io.netty.handler.codec.http.HttpHeaders;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * dec cloud 框架中的 HttpHeader
 * @author DEC
 */
public class DecHttpHeader {

    private Map<String, String> headers;

    public DecHttpHeader(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> headers() {
        return headers;
    }

    public String value(String name) {
        return headers.get(name);
    }

    public void set(String name, String value) {
        headers.put(name, value);
    }

    public void set(DecHttpHeader httpHeader) {
        headers.putAll(httpHeader.headers());
    }

    public static DecHttpHeader of(Map<String, String> map) {
        return new DecHttpHeader(map);
    }

    public static DecHttpHeader of(HttpHeaders headers) {
        Map<String, String> map = new HashMap<>(16);
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = headers.iteratorCharSequence();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return new DecHttpHeader(map);
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return headers.entrySet().iterator();
    }
}
