package io.gitee.declear.dec.cloud.common.web;

import io.gitee.declear.common.utils.CommonUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * dec cloud 框架中的 HttpMethod
 * @author DEC
 */
public class DecHttpMethod {

    /**
     * http请求类型: OPTIONS
     */
    public static final DecHttpMethod OPTIONS = new DecHttpMethod("OPTIONS");

    /**
     * http请求类型: GET
     */
    public static final DecHttpMethod GET = new DecHttpMethod("GET");

    /**
     * http请求类型: HEAD
     */
    public static final DecHttpMethod HEAD = new DecHttpMethod("HEAD");

    /**
     * http请求类型: POST
     */
    public static final DecHttpMethod POST = new DecHttpMethod("POST");

    /**
     * http请求类型: PUT
     */
    public static final DecHttpMethod PUT = new DecHttpMethod("PUT");

    /**
     * http请求类型: PATCH
     */
    public static final DecHttpMethod PATCH = new DecHttpMethod("PATCH");

    /**
     * http请求类型: DELETE
     */
    public static final DecHttpMethod DELETE = new DecHttpMethod("DELETE");

    /**
     * http请求类型: TRACE
     */
    public static final DecHttpMethod TRACE = new DecHttpMethod("TRACE");

    /**
     * http请求类型: CONNECT
     */
    public static final DecHttpMethod CONNECT = new DecHttpMethod("CONNECT");

    private static final Map<String, DecHttpMethod> METHOD_MAP = new HashMap<>();

    static {
        METHOD_MAP.put(OPTIONS.toString(), OPTIONS);
        METHOD_MAP.put(GET.toString(), GET);
        METHOD_MAP.put(HEAD.toString(), HEAD);
        METHOD_MAP.put(POST.toString(), POST);
        METHOD_MAP.put(PUT.toString(), PUT);
        METHOD_MAP.put(PATCH.toString(), PATCH);
        METHOD_MAP.put(DELETE.toString(), DELETE);
        METHOD_MAP.put(TRACE.toString(), TRACE);
        METHOD_MAP.put(CONNECT.toString(), CONNECT);
    }

    private final String name;

    public DecHttpMethod(String name) {
        if(CommonUtils.isEmpty(name)) {
            throw new IllegalArgumentException("invalid http method name, name should not be null");
        }

        for (int i = 0; i < name.length(); i ++) {
            char c = name.charAt(i);
            if (Character.isISOControl(c) || Character.isWhitespace(c)) {
                throw new IllegalArgumentException("invalid character in name");
            }
        }

        this.name = name;
    }

    /**
     * Returns the {@link DecHttpMethod} represented by the specified name.
     * If the specified name is a standard HTTP method name, a cached instance
     * will be returned.  Otherwise, a new instance will be returned.
     */
    public static DecHttpMethod valueOf(String name) {
        DecHttpMethod result = METHOD_MAP.get(name);
        return result != null ? result : new DecHttpMethod(name);
    }

    public String name() {
        return name;
    }

    @Override
    public String toString() {
        return name;
    }
}
