package io.gitee.declear.dec.cloud.common.web;

import io.gitee.declear.dec.cloud.common.constants.Constants;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * dec cloud 框架中的 HttpRequest
 * @author DEC
 */
public class DecHttpRequest {

    private static final Character HTTP_PARAM_START_PREFIX_CHARACTER = '?';
    private static final String HTTP_PARAM_SPLIT_CHARACTER = "&";
    private static final String HTTP_PARAM_AND_COOKIE_VALUE_SPLIT_CHARACTER = "=";
    private static final String HTTP_COOKIE_SPLIT_CHARACTER = ";";

    private String uri;
    private DecHttpMethod method;
    private DecHttpVersion version;

    private DecHttpHeader header;

    @Setter
    private String content;

    @Setter
    private Map<String, String> params;

    private DecHttpCookie[] cookies;

    private String sessionId;

    public DecHttpRequest(String uri, DecHttpMethod method, DecHttpVersion version, DecHttpHeader header) {
        this.method = method;
        this.version = version;
        this.header = header;
        processUri(uri);
    }

    public String uri() {
        return uri;
    }

    public DecHttpMethod method() {
        return method;
    }

    public DecHttpVersion version() {
        return version;
    }

    public DecHttpHeader header() {
        return header;
    }

    public String content() {
        return content;
    }

    public Map<String, String> params() {
        return params;
    }

    public String param(String name) {
        return params.get(name);
    }

    public DecHttpCookie[] cookies() {
        return cookies;
    }

    public String sessionId() {
        return sessionId;
    }

    private void processUri(String uri) {
        // process uri and params
        params = new HashMap<>(2 ^ 3);
        if(uri.indexOf(HTTP_PARAM_START_PREFIX_CHARACTER) != -1) {
            this.uri = uri.substring(0, uri.indexOf(HTTP_PARAM_START_PREFIX_CHARACTER));
            String[] paramStr = uri.substring(uri.indexOf(HTTP_PARAM_START_PREFIX_CHARACTER) + 1).split(HTTP_PARAM_SPLIT_CHARACTER);
            for (String param : paramStr) {
                params.put(param.substring(0, param.indexOf(HTTP_PARAM_AND_COOKIE_VALUE_SPLIT_CHARACTER)),
                        param.substring(param.indexOf(HTTP_PARAM_AND_COOKIE_VALUE_SPLIT_CHARACTER) + 1));
            }
        } else {
            this.uri = uri;
        }

        if(this.uri.charAt(this.uri.length() - 1) == Constants.DEC_CLOUD_HTTP_URI_SPLIT_CHARACTER) {
            this.uri = this.uri.substring(0, uri.length() - 1);
        }

        // process cookies
        if(null != header.headers().get(Constants.DEC_CLOUD_WEB_SERVER_COOKIE)) {
            String cookiesStr = header.headers().get(Constants.DEC_CLOUD_WEB_SERVER_COOKIE);
            String[] cookiesItemStrArr = cookiesStr.split(HTTP_COOKIE_SPLIT_CHARACTER);
            cookies = new DecHttpCookie[cookiesItemStrArr.length];
            for (int i = 0; i < cookiesItemStrArr.length; i++) {
                cookies[i] = new DecHttpCookie(cookiesItemStrArr[i].substring(0, cookiesItemStrArr[i].indexOf(HTTP_PARAM_AND_COOKIE_VALUE_SPLIT_CHARACTER)).trim(),
                        cookiesItemStrArr[i].substring(cookiesItemStrArr[i].indexOf(HTTP_PARAM_AND_COOKIE_VALUE_SPLIT_CHARACTER) + 1).trim());
                if(Objects.equals(cookies[i].getName(), Constants.DEC_CLOUD_WEB_SERVER_SESSION_ID)) {
                    sessionId = cookies[i].getValue();
                }
            }
        }
    }

}
