package io.gitee.declear.dec.cloud.common.web;

import lombok.Setter;

import java.util.HashMap;
import java.util.List;

/**
 * dec cloud 框架中的 HttpResponse
 * @author DEC
 */
public class DecHttpResponse {

    private DecHttpVersion version;

    private DecHttpResponseStatus status;

    private DecHttpHeader header;

    @Setter
    private String content;

    private List<DecHttpCookie> cookies;

    public DecHttpResponse(DecHttpVersion version, DecHttpResponseStatus status) {
        this.version = version;
        this.status = status;
        this.header = DecHttpHeader.of(new HashMap<>());
    }

    public DecHttpVersion version() {
        return version;
    }

    public DecHttpResponseStatus status() {
        return status;
    }

    public String content() {
        return content;
    }

    public DecHttpHeader header() {
        return header;
    }

    public List<DecHttpCookie> cookies() {
        return cookies;
    }

    public void addCookies(DecHttpCookie cookie) {
        cookies.add(cookie);
    }

}
