package io.gitee.declear.dec.cloud.common.web;

/**
 * dec cloud 框架中的 HttpResponseStatus
 * @author DEC
 */
public class DecHttpResponseStatus {

    /**
     * 100 Continue
     */
    public static final DecHttpResponseStatus CONTINUE = newStatus(100, "Continue");

    /**
     * 101 Switching Protocols
     */
    public static final DecHttpResponseStatus SWITCHING_PROTOCOLS = newStatus(101, "Switching Protocols");

    /**
     * 102 Processing (WebDAV, RFC2518)
     */
    public static final DecHttpResponseStatus PROCESSING = newStatus(102, "Processing");

    /**
     * 103 Early Hints (RFC 8297)
     */
    public static final DecHttpResponseStatus EARLY_HINTS = newStatus(103, "Early Hints");

    /**
     * 200 OK
     */
    public static final DecHttpResponseStatus OK = newStatus(200, "OK");

    /**
     * 201 Created
     */
    public static final DecHttpResponseStatus CREATED = newStatus(201, "Created");

    /**
     * 202 Accepted
     */
    public static final DecHttpResponseStatus ACCEPTED = newStatus(202, "Accepted");

    /**
     * 203 Non-Authoritative Information (since HTTP/1.1)
     */
    public static final DecHttpResponseStatus NON_AUTHORITATIVE_INFORMATION =
            newStatus(203, "Non-Authoritative Information");

    /**
     * 204 No Content
     */
    public static final DecHttpResponseStatus NO_CONTENT = newStatus(204, "No Content");

    /**
     * 205 Reset Content
     */
    public static final DecHttpResponseStatus RESET_CONTENT = newStatus(205, "Reset Content");

    /**
     * 206 Partial Content
     */
    public static final DecHttpResponseStatus PARTIAL_CONTENT = newStatus(206, "Partial Content");

    /**
     * 207 Multi-Status (WebDAV, RFC2518)
     */
    public static final DecHttpResponseStatus MULTI_STATUS = newStatus(207, "Multi-Status");

    /**
     * 300 Multiple Choices
     */
    public static final DecHttpResponseStatus MULTIPLE_CHOICES = newStatus(300, "Multiple Choices");

    /**
     * 301 Moved Permanently
     */
    public static final DecHttpResponseStatus MOVED_PERMANENTLY = newStatus(301, "Moved Permanently");

    /**
     * 302 Found
     */
    public static final DecHttpResponseStatus FOUND = newStatus(302, "Found");

    /**
     * 303 See Other (since HTTP/1.1)
     */
    public static final DecHttpResponseStatus SEE_OTHER = newStatus(303, "See Other");

    /**
     * 304 Not Modified
     */
    public static final DecHttpResponseStatus NOT_MODIFIED = newStatus(304, "Not Modified");

    /**
     * 305 Use Proxy (since HTTP/1.1)
     */
    public static final DecHttpResponseStatus USE_PROXY = newStatus(305, "Use Proxy");

    /**
     * 307 Temporary Redirect (since HTTP/1.1)
     */
    public static final DecHttpResponseStatus TEMPORARY_REDIRECT = newStatus(307, "Temporary Redirect");

    /**
     * 308 Permanent Redirect (RFC7538)
     */
    public static final DecHttpResponseStatus PERMANENT_REDIRECT = newStatus(308, "Permanent Redirect");

    /**
     * 400 Bad Request
     */
    public static final DecHttpResponseStatus BAD_REQUEST = newStatus(400, "Bad Request");

    /**
     * 401 Unauthorized
     */
    public static final DecHttpResponseStatus UNAUTHORIZED = newStatus(401, "Unauthorized");

    /**
     * 402 Payment Required
     */
    public static final DecHttpResponseStatus PAYMENT_REQUIRED = newStatus(402, "Payment Required");

    /**
     * 403 Forbidden
     */
    public static final DecHttpResponseStatus FORBIDDEN = newStatus(403, "Forbidden");

    /**
     * 404 Not Found
     */
    public static final DecHttpResponseStatus NOT_FOUND = newStatus(404, "Not Found");

    /**
     * 405 Method Not Allowed
     */
    public static final DecHttpResponseStatus METHOD_NOT_ALLOWED = newStatus(405, "Method Not Allowed");

    /**
     * 406 Not Acceptable
     */
    public static final DecHttpResponseStatus NOT_ACCEPTABLE = newStatus(406, "Not Acceptable");

    /**
     * 407 Proxy Authentication Required
     */
    public static final DecHttpResponseStatus PROXY_AUTHENTICATION_REQUIRED =
            newStatus(407, "Proxy Authentication Required");

    /**
     * 408 Request Timeout
     */
    public static final DecHttpResponseStatus REQUEST_TIMEOUT = newStatus(408, "Request Timeout");

    /**
     * 409 Conflict
     */
    public static final DecHttpResponseStatus CONFLICT = newStatus(409, "Conflict");

    /**
     * 410 Gone
     */
    public static final DecHttpResponseStatus GONE = newStatus(410, "Gone");

    /**
     * 411 Length Required
     */
    public static final DecHttpResponseStatus LENGTH_REQUIRED = newStatus(411, "Length Required");

    /**
     * 412 Precondition Failed
     */
    public static final DecHttpResponseStatus PRECONDITION_FAILED = newStatus(412, "Precondition Failed");

    /**
     * 413 Request Entity Too Large
     */
    public static final DecHttpResponseStatus REQUEST_ENTITY_TOO_LARGE =
            newStatus(413, "Request Entity Too Large");

    /**
     * 414 Request-URI Too Long
     */
    public static final DecHttpResponseStatus REQUEST_URI_TOO_LONG = newStatus(414, "Request-URI Too Long");

    /**
     * 415 Unsupported Media Type
     */
    public static final DecHttpResponseStatus UNSUPPORTED_MEDIA_TYPE = newStatus(415, "Unsupported Media Type");

    /**
     * 416 Requested Range Not Satisfiable
     */
    public static final DecHttpResponseStatus REQUESTED_RANGE_NOT_SATISFIABLE =
            newStatus(416, "Requested Range Not Satisfiable");

    /**
     * 417 Expectation Failed
     */
    public static final DecHttpResponseStatus EXPECTATION_FAILED = newStatus(417, "Expectation Failed");

    /**
     * 421 Misdirected Request
     *
     * @see <a href="https://tools.ietf.org/html/rfc7540#section-9.1.2">421 (Misdirected Request) Status Code</a>
     */
    public static final DecHttpResponseStatus MISDIRECTED_REQUEST = newStatus(421, "Misdirected Request");

    /**
     * 422 Unprocessable Entity (WebDAV, RFC4918)
     */
    public static final DecHttpResponseStatus UNPROCESSABLE_ENTITY = newStatus(422, "Unprocessable Entity");

    /**
     * 423 Locked (WebDAV, RFC4918)
     */
    public static final DecHttpResponseStatus LOCKED = newStatus(423, "Locked");

    /**
     * 424 Failed Dependency (WebDAV, RFC4918)
     */
    public static final DecHttpResponseStatus FAILED_DEPENDENCY = newStatus(424, "Failed Dependency");

    /**
     * 425 Unordered Collection (WebDAV, RFC3648)
     */
    public static final DecHttpResponseStatus UNORDERED_COLLECTION = newStatus(425, "Unordered Collection");

    /**
     * 426 Upgrade Required (RFC2817)
     */
    public static final DecHttpResponseStatus UPGRADE_REQUIRED = newStatus(426, "Upgrade Required");

    /**
     * 428 Precondition Required (RFC6585)
     */
    public static final DecHttpResponseStatus PRECONDITION_REQUIRED = newStatus(428, "Precondition Required");

    /**
     * 429 Too Many Requests (RFC6585)
     */
    public static final DecHttpResponseStatus TOO_MANY_REQUESTS = newStatus(429, "Too Many Requests");

    /**
     * 431 Request Header Fields Too Large (RFC6585)
     */
    public static final DecHttpResponseStatus REQUEST_HEADER_FIELDS_TOO_LARGE =
            newStatus(431, "Request Header Fields Too Large");

    /**
     * 500 Internal Server Error
     */
    public static final DecHttpResponseStatus INTERNAL_SERVER_ERROR = newStatus(500, "Internal Server Error");

    /**
     * 501 Not Implemented
     */
    public static final DecHttpResponseStatus NOT_IMPLEMENTED = newStatus(501, "Not Implemented");

    /**
     * 502 Bad Gateway
     */
    public static final DecHttpResponseStatus BAD_GATEWAY = newStatus(502, "Bad Gateway");

    /**
     * 503 Service Unavailable
     */
    public static final DecHttpResponseStatus SERVICE_UNAVAILABLE = newStatus(503, "Service Unavailable");

    /**
     * 504 Gateway Timeout
     */
    public static final DecHttpResponseStatus GATEWAY_TIMEOUT = newStatus(504, "Gateway Timeout");

    /**
     * 505 HTTP Version Not Supported
     */
    public static final DecHttpResponseStatus HTTP_VERSION_NOT_SUPPORTED =
            newStatus(505, "HTTP Version Not Supported");

    /**
     * 506 Variant Also Negotiates (RFC2295)
     */
    public static final DecHttpResponseStatus VARIANT_ALSO_NEGOTIATES = newStatus(506, "Variant Also Negotiates");

    /**
     * 507 Insufficient Storage (WebDAV, RFC4918)
     */
    public static final DecHttpResponseStatus INSUFFICIENT_STORAGE = newStatus(507, "Insufficient Storage");

    /**
     * 510 Not Extended (RFC2774)
     */
    public static final DecHttpResponseStatus NOT_EXTENDED = newStatus(510, "Not Extended");

    /**
     * 511 Network Authentication Required (RFC6585)
     */
    public static final DecHttpResponseStatus NETWORK_AUTHENTICATION_REQUIRED =
            newStatus(511, "Network Authentication Required");

    private final int code;
    private final String reasonPhrase;

    public DecHttpResponseStatus(int code, String reasonPhrase) {
        this.code = code;
        this.reasonPhrase = reasonPhrase;
    }

    private static DecHttpResponseStatus newStatus(int statusCode, String reasonPhrase) {
        return new DecHttpResponseStatus(statusCode, reasonPhrase);
    }

    public int code() {
        return code;
    }

    @Override
    public String toString() {
        return new StringBuilder(reasonPhrase.length() + 4)
                .append(code)
                .append(' ')
                .append(reasonPhrase)
                .toString();
    }

}
