package io.gitee.declear.dec.cloud.common.web;

import io.gitee.declear.common.utils.CommonUtils;
import lombok.Getter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * dec cloud 框架中的 HttpSession
 * @author DEC
 */
public class DecHttpSession implements Serializable {

    @Serial
    private static final long serialVersionUID = -8174729211552858495L;

    @Getter
    private String sessionId;

    @Getter
    private LocalDateTime createTime;

    @Getter
    private LocalDateTime lastAccessTime;

    private Map<String, Object> attributeMap = new ConcurrentHashMap<>(2 ^ 3);

    public DecHttpSession() {
        this.sessionId = CommonUtils.UUID().toUpperCase();
        createTime = LocalDateTime.now();
        lastAccessTime = createTime;
    }

    public Object attribute(String name) {
        return attributeMap.get(name);
    }

    public void addAttribute(String name, Object attribute) {
        attributeMap.put(name, attribute);
    }
}
