package io.gitee.declear.dec.cloud.common.web;

import java.util.Objects;

/**
 * dec cloud 框架中的 Http协议版本
 * @author DEC
 */
public class DecHttpVersion {

    /**
     * HTTP version 1.1
     */
    public static final DecHttpVersion HTTP_1_1 = new DecHttpVersion("HTTP/1.1");

    /**
     * HTTP version 2
     */
    public static final DecHttpVersion HTTP_2 = new DecHttpVersion("HTTP/2");

    private final String name;

    private DecHttpVersion(String name) {
        this.name = name;
    }

    public String name() {
        return name;
    }

    private static DecHttpVersion newVersion(String name) {
        return new DecHttpVersion(name);
    }

    public static DecHttpVersion ofVersion(String version) {
        if(Objects.equals(version, HTTP_1_1.name())) {
            return HTTP_1_1;
        } else if(Objects.equals(version, HTTP_2.name())) {
            return HTTP_2;
        } else {
            throw new IllegalArgumentException(String.format("server not support http version: %s", version));
        }
    }

}
