package io.gitee.declear.dec.cloud.common.web.context;

import org.springframework.core.NamedThreadLocal;

/**
 * DecWebContext threadLocal holder
 * @author DEC
 */
public class DecWebContextHolder {

    private static final ThreadLocal<DecWebContext> WEB_CONTEXT_THREAD_LOCAL = new NamedThreadLocal<>("web-context");

    public static void setWebContext(DecWebContext context) {
        WEB_CONTEXT_THREAD_LOCAL.remove();
        WEB_CONTEXT_THREAD_LOCAL.set(context);
    }

    public static DecWebContext getWebContext() {
        return WEB_CONTEXT_THREAD_LOCAL.get();
    }

}
