package io.gitee.declear.dec.cloud.common.web.context;

import io.gitee.declear.dec.cloud.common.property.HardWareInfoManager;
import io.gitee.declear.dec.cloud.common.web.DecHttpRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * WebContext 管理
 * @author DEC
 */
public class DecWebContextManager implements ApplicationContextAware {

    @Autowired
    private HardWareInfoManager hardWareInfoManager;

    private ApplicationContext applicationContext;

    private DecWebContextProcessor contextProcessor;

    private Map<String, DecWebContext> webContextMap;

    private Map<String, Method> restUriMap;

    public void init() {
        webContextMap = new ConcurrentHashMap<>(2 ^ 11);
        restUriMap = new ConcurrentHashMap<>(2 ^ 7);
        contextProcessor = new DecWebContextProcessor(applicationContext, hardWareInfoManager, this);
    }

    public void shutdown() {
        if(contextProcessor != null) {
            contextProcessor.shutdown();
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void putProcessWebContext(DecWebContext context) {
        webContextMap.put(context.getId(), context);

        contextProcessor.processDecWebContext(context);
    }

    public void removeWebContext(String id) {
        webContextMap.remove(id);
    }

    public void putRestControllerMap(Map<String, Method> restUriMap) {
        this.restUriMap.putAll(restUriMap);
    }

    public Method getUriServiceMethod(DecHttpRequest request) {
        return restUriMap.get(String.format("%s#%s", request.method().name(), request.uri()));
    }
}
