package dec.service.common.enums;

/**
 * API调用结果 response code
 * @author dec
 */
public enum ResponseCode {

    /**
     * 请求里的参数有错误或者不满足要求
     */
    REQUEST_PARAM_ERROR("DEC_CODE_RESPONSE_10001", "request_param_error"),

    /**
     * 服务处理时内部出错
     */
    SERVICE_INTERNAL_ERROR("DEC_CODE_RESPONSE_10002", "service_internal_error"),

    /**
     * 登录验证错误
     */
    SERVICE_LOGIN_ERROR("DEC_CODE_RESPONSE_10003", "service_login_error"),

    /**
     * 权限验证错误
     */
    SERVICE_AUTH_ERROR("DEC_CODE_RESPONSE_10004", "service_auth_error"),

    /**
     * 服务处理正常
     */
    SERVICE_NORMAL("DEC_CODE_RESPONSE_10020", "service_normal");

    private String code;

    private String value;

    private ResponseCode(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

}
