package dec.service.common.service;

import org.springframework.data.mongodb.core.query.Update;

import java.util.List;

/**
 * common service
 * @author dec
 */
public interface CommonService {

    /**
     * 为一个VO对象生成 Update, 用于数据库update操作.
     * @param object
     * @return
     */
    Update generateUpdate4Mongodb(Object object);

    /**
     * 为一个VO对象生成 Update, 用于数据库update操作.
     * @param object
     * @param isSelective true: 不更新空值
     * @return
     */
    Update generateUpdate4Mongodb(Object object, Boolean isSelective);

    /**
     * 为一个VO对象生成 Update, 用于数据库update操作.
     * @param object
     * @param excludeFields
     * @param isSelective true: 不更新空值
     * @return
     */
    Update generateUpdate4Mongodb(Object object, List<String> excludeFields, Boolean isSelective);

    /**
     * 为一个VO对象生成 Update, 用于数据库update操作.
     * @param object
     * @param includeFields
     * @param excludeFields
     * @param isSelective true: 不更新空值
     * @return
     */
    Update generateUpdate4Mongodb(Object object, List<String> includeFields, List<String> excludeFields, Boolean isSelective);

}