package dec.service.common.service.imp;

import dec.service.common.annotation.NotUpdateField;
import dec.service.common.exception.ServiceInternalException;
import dec.service.common.service.CommonService;
import dec.service.common.utils.CommonUtils;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.List;

/**
 * @author dec
 */
@Service
public class CommonServiceImp implements CommonService {

    @Override
    public Update generateUpdate4Mongodb(Object object) {
        return generateUpdate4Mongodb(object, false);
    }

    @Override
    public Update generateUpdate4Mongodb(Object object, Boolean isSelective) {
        return generateUpdate4Mongodb(object, null, null, isSelective);
    }

    @Override
    public Update generateUpdate4Mongodb(Object object, List<String> excludeFields, Boolean isSelective) {
        return generateUpdate4Mongodb(object, null, excludeFields, isSelective);
    }

    @Override
    public Update generateUpdate4Mongodb(Object object, List<String> includeFields, List<String> excludeFields, Boolean isSelective) {
        Update update = new Update();
        ReflectionUtils.doWithFields(object.getClass(), new ReflectionUtils.FieldCallback() {
            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                // @NotUpdateField注解标注的属性不更新
                if(field.getAnnotationsByType(NotUpdateField.class).length > 0) {
                    return;
                }
                if(CommonUtils.isNotEmpty(includeFields)) {
                    if(CommonUtils.isNotEmpty(excludeFields)) {
                        if(includeFields.contains(field.getName()) && excludeFields.contains(field.getName())) {
                            throw new ServiceInternalException("update error, internal service error: field could not in includeFields and excludeFields both.");
                        }
                        if(includeFields.contains(field.getName())) {
                            field.setAccessible(true);
                            updateAttributes(object, isSelective, field, update, includeFields);
                        }
                    }
                } else if(CommonUtils.isEmpty(excludeFields) || !excludeFields.contains(field.getName())) {
                    field.setAccessible(true);
                    updateAttributes(object, isSelective, field, update, null);
                }
            }
        });

        return update;
    }

    private void updateAttributes(final Object object, final Boolean isSelective, Field field, Update update, List<String> includeFields) throws IllegalAccessException {
        if(isSelective){
            if(CommonUtils.isNotEmpty(field.get(object))) {
                if(field.get(object) instanceof List) {
                    update.push(field.getName()).slice(-((List) field.get(object)).size()).each(field.get(object));
                } else{
                    update.set(field.getName(), field.get(object));
                }
            } else if(CommonUtils.isNotEmpty(includeFields) && includeFields.contains(field.getName())) {
                update.unset(field.getName());
            }
        } else {
            if(CommonUtils.isNotEmpty(field.get(object))) {
                if(field.get(object) instanceof List) {
                    update.push(field.getName()).slice(-((List) field.get(object)).size()).each(field.get(object));
                } else{
                    update.set(field.getName(), field.get(object));
                }
            } else {
                update.unset(field.getName());
            }
        }
    }

}
