/*
 * Decompiled with CFR 0.152.
 */
package dec.service.common.config;

import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FastJsonSerializeFilterConfig {
    private static final String PROPERTY_FILTER_NAME_ID = "id";
    private static final String PROPERTY_FILTER_NAME_PASSWORD = "password";
    private static final String PROPERTY_FILTER_NAME_CREATE_USER = "createUser";
    private static final String PROPERTY_FILTER_NAME_CREATE_DATETIME = "createDateTime";
    private static final String PROPERTY_FILTER_NAME_MODIFY_USER = "modifyUser";
    private static final String PROPERTY_FILTER_NAME_MODIFY_DATETIME = "modifyDateTime";
    private static final ArrayList<String> PROPERTY_FILTER_LIST = new ArrayList();
    private static final String LOCAL_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String LOCAL_DATE_PATTERN = "yyyy-MM-dd";

    @Bean(value={"disIncluded"})
    public PropertyFilter generatePropertyDisIncludedFilter() {
        return new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                return !PROPERTY_FILTER_LIST.contains(name);
            }
        };
    }

    @Bean(value={"localDateTimeFormat"})
    public ValueFilter generateLocalDateTimeFormatFilter() {
        return new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (value instanceof LocalDateTime) {
                    return ((LocalDateTime)value).format(DateTimeFormatter.ofPattern(FastJsonSerializeFilterConfig.LOCAL_DATE_TIME_PATTERN));
                }
                if (value instanceof LocalDate) {
                    return ((LocalDate)value).format(DateTimeFormatter.ofPattern(FastJsonSerializeFilterConfig.LOCAL_DATE_PATTERN));
                }
                return value;
            }
        };
    }

    static {
        PROPERTY_FILTER_LIST.add(PROPERTY_FILTER_NAME_ID);
        PROPERTY_FILTER_LIST.add(PROPERTY_FILTER_NAME_PASSWORD);
        PROPERTY_FILTER_LIST.add(PROPERTY_FILTER_NAME_CREATE_USER);
        PROPERTY_FILTER_LIST.add(PROPERTY_FILTER_NAME_CREATE_DATETIME);
        PROPERTY_FILTER_LIST.add(PROPERTY_FILTER_NAME_MODIFY_USER);
        PROPERTY_FILTER_LIST.add(PROPERTY_FILTER_NAME_MODIFY_DATETIME);
    }
}

