/*
 * Decompiled with CFR 0.152.
 */
package dec.service.common.service.imp;

import dec.service.common.annotation.NotUpdateField;
import dec.service.common.exception.ServiceInternalException;
import dec.service.common.service.CommonService;
import dec.service.common.utils.CommonUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class CommonServiceImp
implements CommonService {
    @Override
    public Update generateUpdate4Mongodb(Object object) {
        return this.generateUpdate4Mongodb(object, false);
    }

    @Override
    public Update generateUpdate4Mongodb(Object object, Boolean isSelective) {
        return this.generateUpdate4Mongodb(object, null, null, isSelective);
    }

    @Override
    public Update generateUpdate4Mongodb(Object object, List<String> excludeFields, Boolean isSelective) {
        return this.generateUpdate4Mongodb(object, null, excludeFields, isSelective);
    }

    @Override
    public Update generateUpdate4Mongodb(final Object object, final List<String> includeFields, final List<String> excludeFields, final Boolean isSelective) {
        final Update update = new Update();
        ReflectionUtils.doWithFields(object.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (((NotUpdateField[])field.getAnnotationsByType(NotUpdateField.class)).length > 0) {
                    return;
                }
                if (CommonUtils.isNotEmpty(includeFields)) {
                    if (CommonUtils.isNotEmpty(excludeFields)) {
                        if (includeFields.contains(field.getName()) && excludeFields.contains(field.getName())) {
                            throw new ServiceInternalException("update error, internal service error: field could not in includeFields and excludeFields both.");
                        }
                        if (includeFields.contains(field.getName())) {
                            field.setAccessible(true);
                            CommonServiceImp.this.updateAttributes(object, isSelective, field, update, includeFields);
                        }
                    }
                } else if (CommonUtils.isEmpty(excludeFields) || !excludeFields.contains(field.getName())) {
                    field.setAccessible(true);
                    CommonServiceImp.this.updateAttributes(object, isSelective, field, update, null);
                }
            }
        });
        return update;
    }

    private void updateAttributes(Object object, Boolean isSelective, Field field, Update update, List<String> includeFields) throws IllegalAccessException {
        if (isSelective.booleanValue()) {
            if (CommonUtils.isNotEmpty(field.get(object))) {
                if (field.get(object) instanceof List) {
                    update.push(field.getName()).slice(-((List)field.get(object)).size()).each(new Object[]{field.get(object)});
                } else {
                    update.set(field.getName(), field.get(object));
                }
            } else if (CommonUtils.isNotEmpty(includeFields) && includeFields.contains(field.getName())) {
                update.unset(field.getName());
            }
        } else if (CommonUtils.isNotEmpty(field.get(object))) {
            if (field.get(object) instanceof List) {
                update.push(field.getName()).slice(-((List)field.get(object)).size()).each(new Object[]{field.get(object)});
            } else {
                update.set(field.getName(), field.get(object));
            }
        } else {
            update.unset(field.getName());
        }
    }
}

