/*
 * Decompiled with CFR 0.152.
 */
package dec.service.common.utils;

import com.alibaba.fastjson.JSONObject;
import dec.service.common.utils.CommonUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final int CONNECT_TIME_OUT = 10000;
    private static final int REQUEST_TIME_OUT = 10000;
    private static final String CHARSET = StandardCharsets.UTF_8.name();

    public static String get(String url, Map<String, String> headers, Map<String, String> parameters) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeaders(HttpUtils.map2Array4Header(headers));
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpGet.setConfig(requestConfig);
        try {
            CloseableHttpClient httpClient = HttpClients.custom().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            return "";
        }
        catch (IOException ex) {
            log.error("get url: {}, parameters: {}", new Object[]{url, JSONObject.toJSONString(parameters), ex});
            return "";
        }
    }

    public static String getWithCredentials(String name, String password, String url, Map<String, String> headers, Map<String, String> parameters) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeaders(HttpUtils.map2Array4Header(headers));
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpGet.setConfig(requestConfig);
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials npCredential = new UsernamePasswordCredentials(name, password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)npCredential);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            return "";
        }
        catch (IOException ex) {
            log.error("get url: {}, parameters: {}", new Object[]{url, JSONObject.toJSONString(parameters), ex});
            return "";
        }
    }

    public static String post(String url, Map<String, String> headers, String content) {
        return HttpUtils.post(url, headers, null, content);
    }

    public static String post(String url, Map<String, String> headers, Map<String, String> parameters, String content) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeaders(HttpUtils.map2Array4Header(headers));
        StringEntity entity = new StringEntity(content, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpPost.setConfig(requestConfig);
        try {
            CloseableHttpClient httpClient = HttpClients.custom().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            log.error("post url:{}, parameters: {}, post body: {}, statusCode: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), statusCode});
            return "";
        }
        catch (IOException ex) {
            log.error("post url:{}, parameters: {}, post body: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), ex});
            return "";
        }
    }

    public static String postWithCredentials(String name, String password, String url, Map<String, String> headers, String content) {
        return HttpUtils.postWithCredentials(name, password, url, headers, null, content);
    }

    public static String postWithCredentials(String name, String password, String url, Map<String, String> headers, Map<String, String> parameters, String content) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeaders(HttpUtils.map2Array4Header(headers));
        StringEntity entity = new StringEntity(content, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpPost.setConfig(requestConfig);
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials npCredential = new UsernamePasswordCredentials(name, password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)npCredential);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            log.error("post url:{}, parameters: {}, post body: {}, statusCode: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), statusCode});
            return "";
        }
        catch (IOException ex) {
            log.error("post url:{}, parameters: {}, post body: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), ex});
            return "";
        }
    }

    public static String put(String url, Map<String, String> headers, String content) {
        return HttpUtils.put(url, headers, null, content);
    }

    public static String put(String url, Map<String, String> headers, Map<String, String> parameters, String content) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeaders(HttpUtils.map2Array4Header(headers));
        StringEntity entity = new StringEntity(content, ContentType.APPLICATION_JSON);
        httpPut.setEntity((HttpEntity)entity);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpPut.setConfig(requestConfig);
        try {
            CloseableHttpClient httpClient = HttpClients.custom().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            log.error("put url:{}, parameters: {}, post body: {}, statusCode: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), statusCode});
            return "";
        }
        catch (IOException ex) {
            log.error("put url:{}, parameters: {}, post body: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), ex});
            return "";
        }
    }

    public static String putWithCredentials(String name, String password, String url, Map<String, String> headers, String content) {
        return HttpUtils.putWithCredentials(name, password, url, headers, null, content);
    }

    public static String putWithCredentials(String name, String password, String url, Map<String, String> headers, Map<String, String> parameters, String content) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeaders(HttpUtils.map2Array4Header(headers));
        StringEntity entity = new StringEntity(content, ContentType.APPLICATION_JSON);
        httpPut.setEntity((HttpEntity)entity);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpPut.setConfig(requestConfig);
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials npCredential = new UsernamePasswordCredentials(name, password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)npCredential);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            log.error("put url:{}, parameters: {}, post body: {}, statusCode: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), statusCode});
            return "";
        }
        catch (IOException ex) {
            log.error("put url:{}, parameters: {}, post body: {}", new Object[]{url, JSONObject.toJSONString(parameters), JSONObject.toJSONString((Object)content), ex});
            return "";
        }
    }

    public static String delete(String url, Map<String, String> headers, Map<String, String> parameters) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpDelete httpDelete = new HttpDelete(uri);
        httpDelete.setHeaders(HttpUtils.map2Array4Header(headers));
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpDelete.setConfig(requestConfig);
        try {
            CloseableHttpClient httpClient = HttpClients.custom().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            return "";
        }
        catch (IOException ex) {
            log.error("delete url: {}, parameters: {}", new Object[]{url, JSONObject.toJSONString(parameters), ex});
            return "";
        }
    }

    public static String deleteWithCredentials(String name, String password, String url, Map<String, String> headers, Map<String, String> parameters) {
        URI uri = HttpUtils.getUri(url, parameters);
        if (uri == null) {
            return "";
        }
        HttpDelete httpDelete = new HttpDelete(uri);
        httpDelete.setHeaders(HttpUtils.map2Array4Header(headers));
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(10000);
        builder.setConnectionRequestTimeout(10000);
        RequestConfig requestConfig = builder.build();
        httpDelete.setConfig(requestConfig);
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials npCredential = new UsernamePasswordCredentials(name, password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)npCredential);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            }
            return "";
        }
        catch (IOException ex) {
            log.error("delete url: {}, parameters: {}", new Object[]{url, JSONObject.toJSONString(parameters), ex});
            return "";
        }
    }

    public static URI getUri(String url, Map<String, String> parameters) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url.trim());
            if (CommonUtils.isEmpty(parameters)) {
                return uriBuilder.build();
            }
            List<NameValuePair> list = HttpUtils.map2List4Parameter(parameters);
            return uriBuilder.setParameters(list).build();
        }
        catch (URISyntaxException ex) {
            log.error("getUri url: {}, parameters: {}", new Object[]{url, JSONObject.toJSONString(parameters), ex});
            return null;
        }
    }

    private static List<NameValuePair> map2List4Parameter(Map<String, String> parameters) {
        if (CommonUtils.isNotEmpty(parameters)) {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(parameters.size());
            parameters.forEach((key, value) -> list.add((NameValuePair)new BasicNameValuePair(key, value)));
            return list;
        }
        return new ArrayList<NameValuePair>();
    }

    private static Header[] map2Array4Header(Map<String, String> headerMap) {
        if (CommonUtils.isNotEmpty(headerMap)) {
            Header[] headers = new Header[headerMap.size()];
            headerMap.forEach((key, value) -> Arrays.fill(headers, new BasicHeader(key, value)));
            return headers;
        }
        return null;
    }
}

