/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.framework.swagger;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.List;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.web.method.HandlerMethod;

public class PermissionOperationCustomizer
implements OperationCustomizer {
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        ArrayList<String> noteList = new ArrayList<String>(this.getPermission(handlerMethod));
        operation.setDescription(StrUtil.join((CharSequence)"<br/>", noteList));
        return operation;
    }

    private List<String> getPermission(HandlerMethod handlerMethod) {
        SaCheckRole methodCheckRole;
        SaCheckPermission methodPermission;
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder permissionStringBuilder = new StringBuilder();
        SaCheckPermission classPermissions = handlerMethod.getBeanType().getAnnotation(SaCheckPermission.class);
        if (classPermissions != null) {
            permissionStringBuilder.append("<font style=\"color:red\" class=\"light-red\">");
            permissionStringBuilder.append("\u7c7b\uff1a").append(this.getAnnotationNote(classPermissions.value(), classPermissions.mode()));
            permissionStringBuilder.append("</font></br>");
        }
        if ((methodPermission = (SaCheckPermission)handlerMethod.getMethodAnnotation(SaCheckPermission.class)) != null) {
            permissionStringBuilder.append("<font style=\"color:red\" class=\"light-red\">");
            permissionStringBuilder.append("\u65b9\u6cd5\uff1a").append(this.getAnnotationNote(methodPermission.value(), methodPermission.mode()));
            permissionStringBuilder.append("</font></br>");
        }
        if (permissionStringBuilder.length() > 0) {
            permissionStringBuilder.insert(0, "<font style=\"color:red\" class=\"light-red\">\u6743\u9650\u6821\u9a8c\uff1a</font></br>");
            values.add(permissionStringBuilder.toString());
        }
        StringBuilder roleStringBuilder = new StringBuilder();
        SaCheckRole classCheckRole = handlerMethod.getBeanType().getAnnotation(SaCheckRole.class);
        if (classCheckRole != null) {
            roleStringBuilder.append("<font style=\"color:red\" class=\"light-red\">");
            roleStringBuilder.append("\u7c7b\uff1a").append(this.getAnnotationNote(classCheckRole.value(), classCheckRole.mode()));
            roleStringBuilder.append("</font></br>");
        }
        if ((methodCheckRole = (SaCheckRole)handlerMethod.getMethodAnnotation(SaCheckRole.class)) != null) {
            roleStringBuilder.append("<font style=\"color:red\" class=\"light-red\">");
            roleStringBuilder.append("\u65b9\u6cd5\uff1a").append(this.getAnnotationNote(methodCheckRole.value(), methodCheckRole.mode()));
            roleStringBuilder.append("</font></br>");
        }
        if (roleStringBuilder.length() > 0) {
            roleStringBuilder.insert(0, "<font style=\"color:red\" class=\"light-red\">\u89d2\u8272\u6821\u9a8c\uff1a</font></br>");
            values.add(roleStringBuilder.toString());
        }
        return values;
    }

    private String getAnnotationNote(String[] values, SaMode mode) {
        if (mode.equals((Object)SaMode.AND)) {
            return String.join((CharSequence)" and ", values);
        }
        return String.join((CharSequence)" or ", values);
    }
}

