/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.framework.swagger;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import io.gitee.dqcer.mcdull.framework.base.annotation.SchemaEnum;
import io.gitee.dqcer.mcdull.framework.base.enums.IEnum;
import io.gitee.dqcer.mcdull.framework.base.vo.KeyValueVO;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springframework.stereotype.Component;

@Component
public class SchemaEnumPropertyCustomizer
implements PropertyCustomizer {
    public Schema customize(Schema schema, AnnotatedType type) {
        if (type.getCtxAnnotations() == null) {
            return schema;
        }
        StringBuilder description = new StringBuilder();
        for (Annotation ctxAnnotation : type.getCtxAnnotations()) {
            if (!ctxAnnotation.annotationType().equals(SchemaEnum.class)) continue;
            description.append(((SchemaEnum)ctxAnnotation).desc());
            Class clazz = ((SchemaEnum)ctxAnnotation).value();
            IEnum[] enumConstants = (IEnum[])clazz.getEnumConstants();
            ArrayList<KeyValueVO> list = new ArrayList<KeyValueVO>();
            for (IEnum iEnum : enumConstants) {
                list.add(new KeyValueVO(iEnum.getCode(), (Object)iEnum.getText()));
            }
            JSONArray objects = JSONUtil.parseArray(list);
            description.append(objects);
        }
        if (description.length() > 0) {
            schema.setDescription(description.toString());
        }
        return schema;
    }
}

