/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dtdage.app.boot.starter.data.mybatis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.gitee.dtdage.app.boot.starter.common.BaseEntity;
import io.gitee.dtdage.app.boot.starter.data.mybatis.context.PageBean;
import io.gitee.dtdage.app.boot.starter.data.mybatis.service.BaseService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseServiceImpl<T extends BaseEntity<? extends Serializable>, M extends BaseMapper<T>>
implements BaseService<T> {
    @Autowired
    private M mapper;

    protected LambdaQueryWrapper<T> queryWrapper(Consumer<LambdaQueryWrapper<T>> consumer) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        consumer.accept(wrapper);
        return wrapper;
    }

    protected LambdaUpdateWrapper<T> updateWrapper(Consumer<LambdaUpdateWrapper<T>> consumer) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        consumer.accept(wrapper);
        return wrapper;
    }

    @Override
    public T create(T param) {
        if (this.mapper.insert(param) > 0) {
            return param;
        }
        throw new RuntimeException("\u6570\u636e\u63d2\u5165\u5f02\u5e38");
    }

    @Override
    public void delete(Serializable masterKey) {
        this.mapper.deleteById(masterKey);
    }

    @Override
    public void delete(Collection<? extends Serializable> list) {
        this.mapper.deleteBatchIds(list);
    }

    @Override
    public void delete(Consumer<LambdaUpdateWrapper<T>> consumer) {
        this.mapper.delete(this.updateWrapper(consumer));
    }

    @Override
    public void update(T param) {
        this.mapper.updateById(param);
    }

    @Override
    public void update(T param, Consumer<LambdaUpdateWrapper<T>> consumer) {
        this.mapper.update(param, this.updateWrapper(consumer));
    }

    @Override
    public T get(Serializable masterKey) {
        return (T)((BaseEntity)this.mapper.selectById(masterKey));
    }

    @Override
    public T get(Consumer<LambdaQueryWrapper<T>> consumer) {
        return (T)((BaseEntity)this.mapper.selectOne(this.queryWrapper(consumer)));
    }

    @Override
    public List<T> query(Consumer<LambdaQueryWrapper<T>> consumer) {
        return this.mapper.selectList(this.queryWrapper(consumer));
    }

    @Override
    public long count(Consumer<LambdaQueryWrapper<T>> consumer) {
        return this.mapper.selectCount(this.queryWrapper(consumer));
    }

    @Override
    public <Page extends PageBean<T>> Page page(Page page, Consumer<LambdaQueryWrapper<T>> consumer) {
        return (Page)((Object)((PageBean)this.mapper.selectPage(page, this.queryWrapper(consumer))));
    }
}

