/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dtdage.app.boot.starter.data.storage.service.impl;

import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import io.gitee.dtdage.app.boot.starter.data.storage.enums.Supplier;
import io.gitee.dtdage.app.boot.starter.data.storage.service.ConfigureService;
import io.gitee.dtdage.app.boot.starter.data.storage.service.StorageService;
import java.io.InputStream;
import org.springframework.stereotype.Service;

@Service
public class QiniuStorageServiceImpl
implements StorageService {
    private final ConfigureService<?> configureService;

    public Supplier getId() {
        return Supplier.qiniu_cloud;
    }

    @Override
    public void delete(String path) throws Exception {
        Object configure = this.configureService.getConfigure(this.getId());
        Auth auth = Auth.create((String)configure.getSecretId(), (String)configure.getSecretKey());
        new BucketManager(auth, new Configuration(Region.autoRegion())).delete(configure.getBucketName(), path);
    }

    @Override
    public String upload(InputStream stream, String filename, String suffix) throws Exception {
        Object configure = this.configureService.getConfigure(this.getId());
        String token = Auth.create((String)configure.getSecretId(), (String)configure.getSecretKey()).uploadToken(configure.getBucketName());
        Configuration configuration = new Configuration(Region.autoRegion());
        configuration.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V2;
        new UploadManager(configuration).put(stream, filename + suffix, token, null, null);
        return configure.getProxyPath() + filename + suffix;
    }

    public QiniuStorageServiceImpl(ConfigureService<?> configureService) {
        this.configureService = configureService;
    }
}

