/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dtdage.app.boot.starter.data.storage.service.impl;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import io.gitee.dtdage.app.boot.starter.data.storage.context.Configure;
import io.gitee.dtdage.app.boot.starter.data.storage.enums.Supplier;
import io.gitee.dtdage.app.boot.starter.data.storage.service.ConfigureService;
import io.gitee.dtdage.app.boot.starter.data.storage.service.StorageService;
import java.io.InputStream;
import org.springframework.stereotype.Service;

@Service
public class TencentStorageServiceImpl
implements StorageService {
    private final ConfigureService<?> configureService;

    public Supplier getId() {
        return Supplier.tencent_cloud;
    }

    private COSClient getClient(Configure configure) {
        BasicCOSCredentials credentials = new BasicCOSCredentials(configure.getSecretId(), configure.getSecretKey());
        return new COSClient((COSCredentials)credentials, new ClientConfig(new Region(configure.getBucketRegion())));
    }

    @Override
    public void delete(String path) {
        Object configure = this.configureService.getConfigure(this.getId());
        this.getClient((Configure)configure).deleteObject(configure.getBucketName(), path);
    }

    @Override
    public String upload(InputStream stream, String filename, String suffix) {
        Object configure = this.configureService.getConfigure(this.getId());
        this.getClient((Configure)configure).putObject(configure.getBucketName(), filename + suffix, stream, null);
        return configure.getProxyPath() + filename + suffix;
    }

    public TencentStorageServiceImpl(ConfigureService<?> configureService) {
        this.configureService = configureService;
    }
}

