/*
 * Decompiled with CFR 0.152.
 */
package com.dss.demo;

import com.dss.demo.ApiDemoUtils;
import com.dss.sdk.api.factory.DssApiSdkFactory;
import com.dss.sdk.api.req.FileDownloadRequest;
import com.dss.sdk.api.req.FileGetFileInfoRequest;
import com.dss.sdk.api.req.FileUploadRequest;
import com.dss.sdk.api.resp.FileGetFileInfoResponse;
import com.dss.sdk.enums.MimeTypeEnum;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DssApiClentDemo {
    private static final String host = "https://dss-dev.fadada.com";
    private static final String appId = "765764";
    private static final String appSecret = "lqdnQUZw3u5rQCLznHz7fEvuzdjhs8Es";
    private static final String filePath = "C:\\temp\\d.pdf";

    public static void main(String[] args) throws Exception {
        DssApiSdkFactory.init(host, appId, appSecret);
        DssApiClentDemo.uploadFile();
        DssApiClentDemo.getFileResult();
        DssApiClentDemo.downFile();
    }

    public static void uploadFile() throws ApiException {
        FileUploadRequest request = new FileUploadRequest();
        request.setFileName("d.pdf");
        request.setFile(new FileItem(filePath));
        DssResponse<FileGetFileInfoResponse> response = DssApiSdkFactory.fileTransferClient.filePreUpload(request);
        ApiDemoUtils.println(response);
    }

    public static void getFileResult() throws ApiException {
        FileGetFileInfoRequest request = new FileGetFileInfoRequest();
        request.setFileId("466298555308347392_cpdf");
        DssResponse<FileGetFileInfoResponse> response = DssApiSdkFactory.fileTransferClient.getFileInfo(request);
        ApiDemoUtils.println(response);
    }

    public static void downFile() throws ApiException, IOException {
        FileDownloadRequest request = new FileDownloadRequest();
        request.setFileId("466298555308347392_cpdf");
        DssResponse<DssEntityResponse> response = DssApiSdkFactory.fileTransferClient.downloadStream(request);
        if (response.isSuccess()) {
            MimeTypeEnum type = MimeTypeEnum.getByContentType(response.getData().getContentType());
            switch (type) {
                case PDF: {
                    File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "test.pdf");
                    if (file.exists()) {
                        file.delete();
                    } else {
                        file.createNewFile();
                    }
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                        bos.write(response.getData().getContent());
                        bos.flush();
                        System.out.println(file.getPath());
                        break;
                    }
                }
            }
        }
    }
}

