/*
 * Decompiled with CFR 0.152.
 */
package com.dss.demo;

import com.dss.demo.ApiDemoUtils;
import com.dss.sdk.api.dto.CoordinateInfo;
import com.dss.sdk.api.dto.DocSignSealInfo;
import com.dss.sdk.api.dto.FileSearchInfo;
import com.dss.sdk.api.dto.LocateCoordinate;
import com.dss.sdk.api.enums.CoordOriginEnum;
import com.dss.sdk.api.enums.SearchStrategyEnum;
import com.dss.sdk.api.enums.SignRuleTypeEnum;
import com.dss.sdk.api.factory.DssApiSdkFactory;
import com.dss.sdk.api.req.form.TextWidgetInfo;
import com.dss.sdk.api.req.form.WidgetData;
import com.dss.sdk.api.req.merge.FileUploadAddDataRequest;
import com.dss.sdk.api.req.merge.FileUploadSignRequest;
import com.dss.sdk.api.resp.FileGetFileInfoResponse;
import com.dss.sdk.api.resp.FileSignSignResponse;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.response.DssResponse;
import com.dss.sdk.utils.random.RandomUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class DssApiMergeDemo {
    private static final String host = "https://dss-dev.fadada.com";
    private static final String appId = "765764";
    private static final String appSecret = "lqdnQUZw3u5rQCLznHz7fEvuzdjhs8Es";
    private static final String filePath = "C:\\temp\\d.pdf";

    public static void main(String[] args) throws Exception {
        DssApiSdkFactory.init(host, appId, appSecret);
        DssApiMergeDemo.uploadPdfAddData();
        DssApiMergeDemo.uploadPdfSign();
        DssApiMergeDemo.uploadSignWithCoordinateInfo();
    }

    public static void uploadPdfAddData() throws ApiException {
        FileUploadAddDataRequest request = new FileUploadAddDataRequest();
        request.setFileName("d.pdf");
        request.setFile(new FileItem(filePath));
        request.setFontSize(Float.valueOf(28.0f));
        request.setFormFlattening(false);
        ArrayList<TextWidgetInfo> list = new ArrayList<TextWidgetInfo>();
        TextWidgetInfo textWidgetInfo = new TextWidgetInfo();
        textWidgetInfo.setPageBegin(1);
        textWidgetInfo.setXs(50.0);
        textWidgetInfo.setYs(50.0);
        textWidgetInfo.setFieldWidth(100.0);
        textWidgetInfo.setFieldHeight(100.0);
        textWidgetInfo.setFieldName("test_add");
        list.add(textWidgetInfo);
        ArrayList<WidgetData> dataList = new ArrayList<WidgetData>();
        WidgetData data = new WidgetData();
        data.setFieldName("test_add");
        data.setFieldValue("\u6d4b\u8bd5\u586b\u5145");
        dataList.add(data);
        request.setTextWidgetInfos(list);
        request.setWidgetDataInfos(dataList);
        DssResponse<FileGetFileInfoResponse> response = DssApiSdkFactory.mergeApiClient.uploadFileAddData(request);
        ApiDemoUtils.println(response);
    }

    public static void uploadPdfSign() throws ApiException {
        FileUploadSignRequest request = new FileUploadSignRequest();
        request.setFileName("d.pdf");
        request.setFile(new FileItem(filePath));
        request.setTransactionId(RandomUtil.randomString(32));
        ArrayList<DocSignSealInfo> sealInfos = new ArrayList<DocSignSealInfo>();
        DocSignSealInfo info = new DocSignSealInfo();
        info.setCertificateId("478959876122484736");
        info.setSealId("478959868832784384");
        info.setRuleType(SignRuleTypeEnum.KEYWORD_SIGN.getReadValue());
        ArrayList<FileSearchInfo> searchInfos = new ArrayList<FileSearchInfo>();
        FileSearchInfo searchInfo = new FileSearchInfo();
        searchInfo.setKeyWord("\u5546\u54c1");
        searchInfo.setKeyWordPolicy(SearchStrategyEnum.LAST.getReadValue());
        searchInfos.add(searchInfo);
        info.setSearchInfos(searchInfos);
        sealInfos.add(info);
        request.setSealInfos(sealInfos);
        DssResponse<FileSignSignResponse> response = DssApiSdkFactory.mergeApiClient.uploadFileSign(request);
        ApiDemoUtils.println(response);
    }

    public static void uploadSignWithCoordinateInfo() throws ApiException {
        FileUploadSignRequest request = new FileUploadSignRequest();
        String filePath = "D:\\tmp\\A4\u6a2a\u7248\u6587\u4ef6.pdf";
        request.setFileName("A4\u6a2a\u7248\u6587\u4ef6.pdf");
        request.setFile(new FileItem(filePath));
        request.setTransactionId(RandomUtil.randomString(32));
        request.setCoordinateInfo(new CoordinateInfo(595.0, CoordOriginEnum.LEFT_BOTTOM.getCode()));
        ArrayList<DocSignSealInfo> sealInfos = new ArrayList<DocSignSealInfo>();
        DocSignSealInfo info = new DocSignSealInfo();
        info.setCertificateId("491968674759979008");
        info.setSealId("478516737198579712");
        info.setRuleType(SignRuleTypeEnum.LOCATION_SIGN.getReadValue());
        LocateCoordinate locateCoordinate = new LocateCoordinate();
        locateCoordinate.setPageNum(1);
        locateCoordinate.setX(698.0);
        locateCoordinate.setY(136.0);
        info.setLocateCoordinates(Arrays.asList(locateCoordinate));
        sealInfos.add(info);
        request.setSealInfos(sealInfos);
        DssResponse<FileSignSignResponse> response = DssApiSdkFactory.mergeApiClient.uploadFileSign(request);
        ApiDemoUtils.println(response);
    }
}

