/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.api.base;

import com.dss.sdk.annotation.IgnoreField;
import com.dss.sdk.annotation.ValidField;
import com.dss.sdk.exception.ApiRuleException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.request.DssRequest;
import com.dss.sdk.utils.string.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDssRequest
implements DssRequest {
    @IgnoreField
    public static final String ERROR_CODE_ARGUMENTS_MISSING = "40";
    @IgnoreField
    public static final String ERROR_CODE_ARGUMENTS_INVALID = "41";
    @IgnoreField
    private static final Logger log = LoggerFactory.getLogger(BaseDssRequest.class);
    @IgnoreField
    private final String reqId = StrUtil.fastSimpleUUID();
    @IgnoreField
    private String httpMethod = "POST";

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public String getHttpId() {
        return this.reqId;
    }

    @Override
    public Map<String, Object> toMap() throws ApiRuleException {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        Field[] fields = BaseDssRequest.getAllFields(this.getClass());
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (FileItem.class.getTypeName().equals(field.getType().getTypeName()) || field.isSynthetic()) continue;
            String key = field.getName();
            try {
                this.setFieldAccessible(field);
                Object object = field.get(this);
                IgnoreField validation = field.getAnnotation(IgnoreField.class);
                if (validation != null) continue;
                if (null != object && List.class.isAssignableFrom(object.getClass())) {
                    ParameterizedType listGenericType = (ParameterizedType)field.getGenericType();
                    Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
                    Type listActualTypeArgument = listActualTypeArguments[0];
                    Class itemType = null;
                    if (listActualTypeArgument instanceof Class) {
                        itemType = (Class)listActualTypeArgument;
                    }
                    ArrayList arrayField = (ArrayList)object;
                    ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>();
                    for (int j = 0; j < arrayField.size(); ++j) {
                        if (null != itemType && BaseDssRequest.class.isAssignableFrom(itemType)) {
                            Map<String, Object> filedMap = ((BaseDssRequest)arrayField.get(j)).toMap();
                            fieldList.add(filedMap);
                            continue;
                        }
                        fieldList.add((Map<String, Object>)arrayField.get(j));
                    }
                    map.put(key, fieldList);
                    continue;
                }
                if (null != object && BaseDssRequest.class.isAssignableFrom(object.getClass())) {
                    BaseDssRequest baseModel = (BaseDssRequest)object;
                    map.put(key, baseModel.toMap());
                    continue;
                }
                this.setValue(map, key, object);
                continue;
            }
            catch (Exception e) {
                log.error("client-error:Reflect Field {} Exception:{}", (Object)key, (Object)StrUtil.blankToDefault(e.getMessage(), e.getLocalizedMessage()));
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Reflect Field arguments:" + key);
            }
        }
        return map;
    }

    private void setValue(Map<String, Object> map, String key, Object value) {
        if (map.containsKey(key) && value == null) {
            return;
        }
        map.put(key, value);
    }

    @Override
    public void validate() throws ApiRuleException {
        Field[] fields;
        for (Field field : fields = BaseDssRequest.getAllFields(this.getClass())) {
            try {
                this.setFieldAccessible(field);
                Object object = field.get(this);
                ValidField validation = field.getAnnotation(ValidField.class);
                if (validation == null) continue;
                boolean required = validation.required();
                if (required && null == object) {
                    throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISSING, "client-error:Missing required arguments:" + field.getName());
                }
                if (required && object instanceof String && ((String)object).trim().length() == 0) {
                    throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISSING, "client-error:Missing required arguments:" + field.getName());
                }
                if (validation.maxLength() > 0 && object instanceof String && ((String)object).length() > validation.maxLength()) {
                    throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the string length of " + field.getName() + " can not be larger than " + validation.maxLength() + ".");
                }
                if (validation.maxLength() > 0 && object instanceof FileItem && ((FileItem)object).getFileLength() > (long)validation.maxLength()) {
                    throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the file size of " + field.getName() + " can not be larger than " + validation.maxLength() + ".");
                }
                if (validation.maxLength() > 0 && object instanceof List && object != null && ((List)object).size() > validation.maxLength()) {
                    throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the array size of " + field.getName() + " must be less than " + validation.maxLength() + ".");
                }
                if (validation.maxLength() <= 0 || !(object instanceof Long) || (Long)object <= (long)validation.maxLength()) continue;
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the array size of " + field.getName() + " must be less than " + validation.maxLength() + ".");
            }
            catch (Exception e) {
                if (e instanceof ApiRuleException) {
                    throw (ApiRuleException)e;
                }
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Get Field " + field.getName() + " is Exception");
            }
        }
    }

    private void setFieldAccessible(Field field) {
        boolean isAccess;
        boolean bl = isAccess = (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) && !field.isAccessible();
        if (isAccess) {
            field.setAccessible(true);
        }
    }

    public static Field[] getAllFields(Class<?> clazz) {
        LinkedHashSet<Field> allFieldsSet = new LinkedHashSet<Field>();
        Field[] fields = clazz.getDeclaredFields();
        allFieldsSet.addAll(Arrays.asList(fields));
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            fields = currentClass.getDeclaredFields();
            allFieldsSet.addAll(Arrays.asList(fields));
        }
        return allFieldsSet.toArray(new Field[0]);
    }
}

