/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.api.base;

import com.dss.sdk.api.base.FddClient;
import com.dss.sdk.base.BaseClient;
import com.dss.sdk.config.HttpConfig;
import com.dss.sdk.enums.SignDataEnum;
import com.dss.sdk.enums.SignTypeEnum;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.exception.ApiRuleException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.request.DssRequest;
import com.dss.sdk.request.DssUploadRequest;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;
import com.dss.sdk.stratey.DefaultJsonStrategy;
import com.dss.sdk.stratey.JsonStrategy;
import com.dss.sdk.utils.crypt.DSSCryptUtil;
import com.dss.sdk.utils.http.HttpUtil;
import com.dss.sdk.utils.http.RequestParametersHolder;
import com.dss.sdk.utils.json.ParameterizedTypeBaseRes;
import com.dss.sdk.utils.log.DssLogUtil;
import com.dss.sdk.utils.string.StrUtil;
import com.dss.sdk.utils.url.DssUrlUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDssClient
extends BaseClient
implements FddClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDssClient.class);
    protected String serverUrl;
    protected String signType = SignTypeEnum.SHA256.getValue();
    protected String language = "zh-CN";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needCheckRequest = true;
    private HttpConfig httpConfig;
    private JsonStrategy jsonStrategy = new DefaultJsonStrategy();

    public DefaultDssClient(String serverUrl, String appId, String appSecret) {
        super(appId, appSecret);
        this.serverUrl = serverUrl;
        this.setDefaultHttpConfig();
    }

    public DefaultDssClient(String serverUrl, String appId, String appSecret, HttpConfig httpConfig) {
        super(appId, appSecret);
        this.serverUrl = serverUrl;
        if (httpConfig == null) {
            this.setDefaultHttpConfig();
        } else {
            this.setHttpConfig(httpConfig);
        }
    }

    public DefaultDssClient(String serverUrl, String appId, String appSecret, int connectTimeout, int readTimeout) {
        super(appId, appSecret);
        this.serverUrl = serverUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.setDefaultHttpConfig();
    }

    public DefaultDssClient(String serverUrl, String appId, String appSecret, int connectTimeout, int readTimeout, String signType) {
        super(appId, appSecret);
        this.serverUrl = serverUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.signType = signType;
        this.setDefaultHttpConfig();
    }

    @Override
    public <T> DssResponse<T> execute(DssRequest request, String apiPath, Class<T> clzz) throws ApiException {
        DssResponse tRsp;
        DssLogUtil.logVersion();
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        DssResponse response = this.doExecute(request, apiPath, clzz, false, null, requestHolder);
        if (response == null) {
            return null;
        }
        if (requestHolder.getResponseBody() == null) {
            return response;
        }
        try {
            tRsp = (DssResponse)this.getJsonStrategy().toBean(requestHolder.getResponseBody(), new ParameterizedTypeBaseRes(clzz));
        }
        catch (Exception e) {
            log.error("converter toResponse fail appId:{},methodName:{},serverUrl:{},exception:{}", new Object[]{this.getAppId(), apiPath, this.serverUrl, e.toString()});
            throw new ApiException(e);
        }
        if (!tRsp.isSuccess() && log.isDebugEnabled()) {
            log.debug("appId:{},methodName:{},serverUrl:{},allParams:{},exception:{}", new Object[]{this.getAppId(), apiPath, this.serverUrl, requestHolder.getAllParams(), requestHolder.getResponseBody()});
        }
        return tRsp;
    }

    @Override
    public <T> DssResponse<List<T>> executeList(DssRequest request, String apiPath, Class<T> clzz) throws ApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        DssResponse response = this.doExecute(request, apiPath, clzz, false, null, requestHolder);
        if (response == null) {
            return null;
        }
        DssResponse tRsp = this.getJsonStrategy().toBean(requestHolder.getResponseBody(), DssResponse.class);
        Object data = response.getData();
        if (data != null) {
            String jsonStr = data instanceof String ? String.valueOf(data) : this.getJsonStrategy().toJson(data);
            List<T> lists = this.getJsonStrategy().toList(jsonStr, clzz);
            tRsp.setData(lists);
        }
        if (!tRsp.isSuccess() && log.isDebugEnabled()) {
            log.debug("appId:{},methodName:{},serverUrl:{},allParams:{},exception:{}", new Object[]{this.getAppId(), apiPath, this.serverUrl, requestHolder.getAllParams(), requestHolder.getResponseBody()});
        }
        return tRsp;
    }

    @Override
    public DssResponse<DssEntityResponse> executeDownload(DssRequest request, String apiPath) throws ApiException {
        return this.doExecute(request, apiPath, null, true, null, new RequestParametersHolder());
    }

    private DssResponse doExecute(DssRequest request, String apiPath, Class clzz, boolean isDown, String session, RequestParametersHolder requestHolder) throws ApiException {
        long start = System.currentTimeMillis();
        if (this.needCheckRequest) {
            try {
                request.validate();
            }
            catch (ApiRuleException e) {
                DssResponse localResponse = new DssResponse();
                try {
                    localResponse.setData(clzz.newInstance());
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setCode(e.getErrCode());
                localResponse.setMessage(e.getErrMsg());
                return localResponse;
            }
        }
        HashMap<String, Object> appParams = new HashMap<String, Object>(request.toMap());
        requestHolder.setApplicationParams(appParams);
        if (StrUtil.isNotBlank(session)) {
            HashMap<String, String> protocalOptParams = new HashMap<String, String>(8);
            protocalOptParams.put("session", session);
            requestHolder.setProtocalOptParams(protocalOptParams);
        }
        HashMap<String, String> headParams = DSSCryptUtil.getHeaderMap(this.getAppId(), this.signType, this.language);
        HashMap<String, String> protocalMustParams = new HashMap<String, String>(headParams);
        protocalMustParams.remove(SignDataEnum.LANGUAGE.getName());
        if (request instanceof DssUploadRequest) {
            DSSCryptUtil.getFormSign(protocalMustParams, appParams, this.getAppSecret());
        } else {
            DSSCryptUtil.getSign(protocalMustParams, this.getJsonStrategy().toJson(appParams), this.getAppSecret());
        }
        headParams.put(SignDataEnum.SIGN.getName(), protocalMustParams.get(SignDataEnum.SIGN.getName()));
        requestHolder.setProtocalMustParams(protocalMustParams);
        if (this.httpConfig.getUseGzipEncoding().booleanValue()) {
            headParams.put("Accept-Encoding", "gzip");
        }
        headParams.put("X-Request-Id", StrUtil.blankToDefault(request.getHttpId(), StrUtil.fastSimpleUUID()));
        try {
            DssResponse<DssEntityResponse> res;
            String realServerUrl = DssUrlUtils.getServerUrl(this.serverUrl, apiPath, session, appParams);
            String fullUrl = DssUrlUtils.buildRequestUrl(realServerUrl, new String[0]);
            requestHolder.setRequestUrl(fullUrl);
            if ("POST".equals(request.getHttpMethod())) {
                Object body;
                Map<String, FileItem> fileParams = null;
                if (request instanceof DssUploadRequest) {
                    DssUploadRequest uRequest = (DssUploadRequest)request;
                    fileParams = StrUtil.cleanupMap(uRequest.getFileParams());
                    body = appParams;
                } else {
                    body = this.getJsonStrategy().toJson(appParams);
                }
                if (isDown) {
                    DssEntityResponse baseResponseEntity = this.requestDown(fullUrl, headParams, (String)body);
                    if (baseResponseEntity.getData() != null) {
                        res = this.getJsonStrategy().toBean(baseResponseEntity.getData(), DssResponse.class);
                    } else {
                        res = new DssResponse<DssEntityResponse>("0", Boolean.TRUE, apiPath);
                        res.setData(baseResponseEntity);
                    }
                } else {
                    res = HttpUtil.post(fullUrl, headParams, body, fileParams, requestHolder);
                }
            } else {
                res = HttpUtil.get(fullUrl, headParams, appParams, requestHolder);
            }
            if (res == null) {
                return null;
            }
            return res;
        }
        catch (Exception e) {
            log.error("appId:{},methodName:{},serverUrl:{},resTime:{},headerParams:{},bodyParams:{},exception:{}", new Object[]{this.getAppId(), apiPath, this.serverUrl, System.currentTimeMillis() - start, this.jsonStrategy.toJson(requestHolder.getProtocalMustParams()), this.jsonStrategy.toJson(requestHolder.getApplicationParams()), e.toString()});
            throw new ApiException(e);
        }
    }

    private DssEntityResponse requestDown(String url, Map<String, String> headerMap, String body) throws ApiException {
        try {
            return HttpUtil.downLoadFiles(url, headerMap, body);
        }
        catch (Exception e) {
            log.error("httpDownLoad\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("httpDownLoad\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        if (serverUrl != null) {
            this.serverUrl = serverUrl;
        }
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        if (signType != null) {
            this.signType = signType;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (language != null) {
            this.language = language;
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        if (httpConfig != null) {
            HttpUtil.httpConfig = this.httpConfig = httpConfig;
        }
    }

    public JsonStrategy getJsonStrategy() {
        return this.jsonStrategy;
    }

    public void setJsonStrategy(JsonStrategy jsonStrategy) {
        if (jsonStrategy != null) {
            this.jsonStrategy = jsonStrategy;
        }
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    private void setDefaultHttpConfig() {
        if (this.httpConfig == null) {
            this.httpConfig = new HttpConfig(this.connectTimeout, this.readTimeout);
        } else {
            this.httpConfig.setConnectTimeout(this.connectTimeout);
            this.httpConfig.setReadTimeout(this.readTimeout);
        }
        this.setHttpConfig(this.httpConfig);
    }
}

