/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.api.client;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.SealBaseRequest;
import com.dss.sdk.api.req.SealCreateDrawResultRequest;
import com.dss.sdk.api.req.SealCreateDrawUrlRequest;
import com.dss.sdk.api.req.SealCreateImageRequest;
import com.dss.sdk.api.req.SealCreateRequest;
import com.dss.sdk.api.req.SealDownloadRequest;
import com.dss.sdk.api.req.SealPreviewRequest;
import com.dss.sdk.api.req.SealQueryRequest;
import com.dss.sdk.api.req.SealRemarkPreviewRequest;
import com.dss.sdk.api.resp.SealCreateDrawResultResponse;
import com.dss.sdk.api.resp.SealCreateDrawUrlResponse;
import com.dss.sdk.api.resp.SealQueryResponse;
import com.dss.sdk.api.resp.SealStyleInfoResponse;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;

public class SealApiClient
extends BaseApi {
    public SealApiClient(DssClientService clientService) {
        super(clientService);
    }

    public DssResponse<DssEntityResponse> previewPerson(SealPreviewRequest sealPreviewRequest) throws ApiException {
        return this.clientService.executeDownload(sealPreviewRequest, "/api/seal/preview/person");
    }

    public DssResponse<DssEntityResponse> previewCompany(SealPreviewRequest sealPreviewRequest) throws ApiException {
        return this.clientService.executeDownload(sealPreviewRequest, "/api/seal/preview/company");
    }

    public DssResponse<DssEntityResponse> previewRemark(SealRemarkPreviewRequest request) throws ApiException {
        return this.clientService.executeDownload(request, "/api/seal/preview/remark");
    }

    public DssResponse<DssEntityResponse> download(SealDownloadRequest sealDownloadRequest) throws ApiException {
        return this.clientService.executeDownload(sealDownloadRequest, "/api/seal/download");
    }

    public DssResponse<SealStyleInfoResponse> createPerson(SealCreateRequest request) throws ApiException {
        return this.clientService.execute(request, "/api/seal/create/person", SealStyleInfoResponse.class);
    }

    public DssResponse<SealStyleInfoResponse> createCompany(SealCreateRequest request) throws ApiException {
        return this.clientService.execute(request, "/api/seal/create/company", SealStyleInfoResponse.class);
    }

    public DssResponse<SealStyleInfoResponse> createImage(SealCreateImageRequest request) throws ApiException {
        return this.clientService.execute(request, "/api/seal/create/image", SealStyleInfoResponse.class);
    }

    public DssResponse<SealCreateDrawUrlResponse> createDrawUrl(SealCreateDrawUrlRequest request) throws ApiException {
        return this.clientService.execute(request, "/api/seal/create/draw/url", SealCreateDrawUrlResponse.class);
    }

    public DssResponse<SealCreateDrawResultResponse> createDrawResult(SealCreateDrawResultRequest request) throws ApiException {
        return this.clientService.execute(request, "/api/seal/create/draw/result", SealCreateDrawResultResponse.class);
    }

    public DssResponse<SealStyleInfoResponse> queryInfo(SealBaseRequest sealBaseRequest) throws ApiException {
        return this.clientService.execute(sealBaseRequest, "/api/seal/query/info", SealStyleInfoResponse.class);
    }

    public DssResponse<SealQueryResponse> queryPage(SealQueryRequest request) throws ApiException {
        return this.clientService.execute(request, "/api/seal/query/page", SealQueryResponse.class);
    }

    public DssResponse delete(SealBaseRequest sealBaseRequest) throws ApiException {
        return this.clientService.execute(sealBaseRequest, "/api/seal/delete", Void.class);
    }
}

