/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.api.client.merge;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.FileSignSignRequest;
import com.dss.sdk.api.req.FileUploadRequest;
import com.dss.sdk.api.req.form.FileFormRequest;
import com.dss.sdk.api.req.merge.FileUploadAddDataRequest;
import com.dss.sdk.api.req.merge.FileUploadSignRequest;
import com.dss.sdk.api.resp.FileGetFileInfoResponse;
import com.dss.sdk.api.resp.FileSignSignResponse;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.response.DssResponse;
import com.dss.sdk.stratey.JsonStrategy;

public class MergeApiClient
extends BaseApi {
    public MergeApiClient(DssClientService clientService) {
        super(clientService);
    }

    public DssResponse<FileGetFileInfoResponse> uploadFileAddData(FileUploadAddDataRequest request) throws ApiException {
        DssResponse<FileGetFileInfoResponse> response;
        this.clientService.setNeedCheckRequest(false);
        FileItem fileItem = null;
        if (request.getFile() != null) {
            fileItem = request.getFile();
            request.setFile(null);
        }
        JsonStrategy jsonStrategy = this.clientService.getJsonStrategy();
        String dataJson = jsonStrategy.toJson(request);
        FileUploadRequest uploadRequest = jsonStrategy.toBean(dataJson, FileUploadRequest.class);
        FileFormRequest formRequest = jsonStrategy.toBean(dataJson, FileFormRequest.class);
        if (fileItem != null) {
            uploadRequest.setFile(fileItem);
        }
        if (!(response = this.clientService.execute(uploadRequest, "/api/file/upload", FileGetFileInfoResponse.class)).isSuccess()) {
            throw new ApiException(response.getCode(), response.getMessage());
        }
        formRequest.setFileId(response.getData().getFileId());
        this.clientService.setNeedCheckRequest(true);
        return this.clientService.execute(formRequest, "/api/file/form/data", FileGetFileInfoResponse.class);
    }

    public DssResponse<FileSignSignResponse> uploadFileSign(FileUploadSignRequest request) throws ApiException {
        DssResponse<FileGetFileInfoResponse> response;
        this.clientService.setNeedCheckRequest(false);
        FileItem fileItem = null;
        if (request.getFile() != null) {
            fileItem = request.getFile();
            request.setFile(null);
        }
        JsonStrategy jsonStrategy = this.clientService.getJsonStrategy();
        String dataJson = jsonStrategy.toJson(request);
        FileUploadRequest uploadRequest = jsonStrategy.toBean(dataJson, FileUploadRequest.class);
        FileSignSignRequest signRequest = jsonStrategy.toBean(dataJson, FileSignSignRequest.class);
        if (fileItem != null) {
            uploadRequest.setFile(fileItem);
        }
        if (!(response = this.clientService.execute(uploadRequest, "/api/file/upload", FileGetFileInfoResponse.class)).isSuccess()) {
            throw new ApiException(response.getCode(), response.getMessage());
        }
        signRequest.setFileId(response.getData().getFileId());
        this.clientService.setNeedCheckRequest(true);
        return this.clientService.execute(signRequest, "/api/file/sign", FileSignSignResponse.class);
    }
}

