/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.api.enums;

import com.dss.sdk.api.enums.ReadableEnum;
import lombok.Generated;

public enum FileTypeEnum implements ReadableEnum<FileTypeEnum>
{
    PDF_FILE(1, "pdf", ".pdf", "pdf\u6587\u4ef6\u7c7b\u578b"),
    OFD_FILE(2, "ofd", ".ofd", "ofd\u6587\u4ef6\u7c7b\u578b");

    private Integer type;
    private String name;
    private String suffix;
    private String desc;

    public static boolean isValidKey(Integer type) {
        if (null == type) {
            return true;
        }
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static FileTypeEnum getFileType(Integer type) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public static FileTypeEnum getByName(String name) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }

    public static FileTypeEnum getByName(String name, FileTypeEnum defaultEnum) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return defaultEnum;
    }

    public static FileTypeEnum getByNameIgnoreCase(String name) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static FileTypeEnum getBySuffix(String suffix) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (!value.getSuffix().equals(suffix)) continue;
            return value;
        }
        return null;
    }

    public static boolean isPdfOrOfd(String name) {
        return PDF_FILE.getName().equalsIgnoreCase(name) || OFD_FILE.getName().equalsIgnoreCase(name);
    }

    public static boolean isPdf(String name) {
        return PDF_FILE.getName().equalsIgnoreCase(name);
    }

    public static boolean isOfd(String name) {
        return OFD_FILE.getName().equalsIgnoreCase(name);
    }

    public static boolean isOfd(Integer type) {
        return OFD_FILE.getType().equals(type);
    }

    public static boolean isPdfOrOfd(FileTypeEnum typeEnum) {
        return PDF_FILE.equals(typeEnum) || OFD_FILE.equals(typeEnum);
    }

    @Override
    public String getReadValue() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    private FileTypeEnum(Integer type, String name, String suffix, String desc) {
        this.type = type;
        this.name = name;
        this.suffix = suffix;
        this.desc = desc;
    }
}

