/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.api.factory;

import com.dss.sdk.api.client.FileOperateClient;
import com.dss.sdk.api.client.FileSignClient;
import com.dss.sdk.api.client.FileTransferClient;
import com.dss.sdk.api.client.FileVerifyClient;
import com.dss.sdk.api.client.ReportClient;
import com.dss.sdk.api.client.SealApiClient;
import com.dss.sdk.api.client.ToolApiClient;
import com.dss.sdk.api.client.ZxcaApiClient;
import com.dss.sdk.api.client.merge.MergeApiClient;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.config.HttpConfig;

public class DssApiSdkFactory {
    private static DssClientService clientService;
    public static FileOperateClient fileOperateClient;
    public static FileSignClient fileSignClient;
    public static FileTransferClient fileTransferClient;
    public static FileVerifyClient fileVerifyClient;
    public static ReportClient reportClient;
    public static SealApiClient sealApiClient;
    public static ZxcaApiClient zxcaApiClient;
    public static MergeApiClient mergeApiClient;
    public static ToolApiClient toolApiClient;

    public static void init(String serverUrl, String appId, String appSecret) {
        clientService = new DssClientService(serverUrl, appId, appSecret);
        DssApiSdkFactory.Transaction();
    }

    public static void init(String serverUrl, String appId, String appSecret, HttpConfig httpConfig) {
        clientService = new DssClientService(serverUrl, appId, appSecret, httpConfig);
        DssApiSdkFactory.Transaction();
    }

    private static void Transaction() {
        fileOperateClient = new FileOperateClient(clientService);
        fileSignClient = new FileSignClient(clientService);
        fileTransferClient = new FileTransferClient(clientService);
        fileVerifyClient = new FileVerifyClient(clientService);
        reportClient = new ReportClient(clientService);
        sealApiClient = new SealApiClient(clientService);
        zxcaApiClient = new ZxcaApiClient(clientService);
        mergeApiClient = new MergeApiClient(clientService);
        toolApiClient = new ToolApiClient(clientService);
    }
}

