/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.enums;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum MimeTypeEnum {
    AAC("acc", "AAC\u97f3\u9891", "audio/aac"),
    ABW("abw", "AbiWord\u6587\u4ef6", "application/x-abiword"),
    ARC("arc", "\u5b58\u6863\u6587\u4ef6", "application/x-freearc"),
    AVI("avi", "\u97f3\u9891\u89c6\u9891\u4ea4\u9519\u683c\u5f0f", "video/x-msvideo"),
    AZW("azw", "\u4e9a\u9a6c\u900aKindle\u7535\u5b50\u4e66\u683c\u5f0f", "application/vnd.amazon.ebook"),
    BIN("bin", "\u4efb\u4f55\u7c7b\u578b\u7684\u4e8c\u8fdb\u5236\u6570\u636e", "application/octet-stream"),
    BMP("bmp", "Windows OS / 2\u4f4d\u56fe\u56fe\u5f62", "image/bmp"),
    BZ("bz", "BZip\u5b58\u6863", "application/x-bzip"),
    BZ2("bz2", "BZip2\u5b58\u6863", "application/x-bzip2"),
    CSH("csh", "C-Shell\u811a\u672c", "application/x-csh"),
    CSS("css", "\u7ea7\u8054\u6837\u5f0f\u8868\uff08CSS\uff09", "text/css"),
    CSV("csv", "\u9017\u53f7\u5206\u9694\u503c\uff08CSV\uff09", "text/csv"),
    DOC("doc", "\u5fae\u8f6fWord\u6587\u4ef6", "application/msword"),
    DOCX("docx", "Microsoft Word\uff08OpenXML\uff09", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    EOT("eot", "MS Embedded OpenType\u5b57\u4f53", "application/vnd.ms-fontobject"),
    EPUB("epub", "\u7535\u5b50\u51fa\u7248\u7269\uff08EPUB\uff09", "application/epub+zip"),
    GZ("gz", "GZip\u538b\u7f29\u6863\u6848", "application/gzip"),
    GIF("gif", "\u56fe\u5f62\u4ea4\u6362\u683c\u5f0f\uff08GIF\uff09", "image/gif"),
    HTM("htm", "\u8d85\u6587\u672c\u6807\u8bb0\u8bed\u8a00\uff08HTML\uff09", "text/html"),
    HTML("html", "\u8d85\u6587\u672c\u6807\u8bb0\u8bed\u8a00\uff08HTML\uff09", "text/html"),
    ICO("ico", "\u56fe\u6807\u683c\u5f0f", "image/vnd.microsoft.icon"),
    ICS("ics", "iCalendar\u683c\u5f0f", "text/calendar"),
    JAR("jar", "Java\u5b58\u6863", "application/java-archive"),
    JPEG("jpeg", "JPEG\u56fe\u50cf", "image/jpeg"),
    JPG("jpg", "JPEG\u56fe\u50cf", "image/jpeg"),
    JS("js", "JavaScript", "text/javascript"),
    JSON("json", "JSON\u683c\u5f0f", "application/json"),
    JSONLD("jsonld", "JSON-LD\u683c\u5f0f", "application/ld+json"),
    MID("mid", "\u4e50\u5668\u6570\u5b57\u63a5\u53e3\uff08MIDI\uff09", "audio/midi"),
    MIDI("midi", "\u4e50\u5668\u6570\u5b57\u63a5\u53e3\uff08MIDI\uff09", "audio/midi"),
    MJS("mjs", "JavaScript\u6a21\u5757", "text/javascript"),
    MP3("mp3", "MP3\u97f3\u9891", "audio/mpeg"),
    MPEG("mpeg", "MPEG\u89c6\u9891", "video/mpeg"),
    MPKG("mpkg", "\u82f9\u679c\u5b89\u88c5\u7a0b\u5e8f\u5305", "application/vnd.apple.installer+xml"),
    ODP("odp", "OpenDocument\u6f14\u793a\u6587\u7a3f\u6587\u6863", "application/vnd.oasis.opendocument.presentation"),
    ODS("ods", "OpenDocument\u7535\u5b50\u8868\u683c\u6587\u6863", "application/vnd.oasis.opendocument.spreadsheet"),
    ODT("odt", "OpenDocument\u6587\u5b57\u6587\u4ef6", "application/vnd.oasis.opendocument.text"),
    OGA("oga", "OGG\u97f3\u8baf", "audio/ogg"),
    OGV("ogv", "OGG\u89c6\u9891", "video/ogg"),
    OGX("ogx", "OGG", "application/ogg"),
    OPUS("opus", "OPUS\u97f3\u9891", "audio/opus"),
    OTF("otf", "otf\u5b57\u4f53", "font/otf"),
    PNG("png", "\u4fbf\u643a\u5f0f\u7f51\u7edc\u56fe\u5f62", "image/png"),
    PDF("pdf", "Adobe \u53ef\u79fb\u690d\u6587\u6863\u683c\u5f0f\uff08PDF\uff09", "application/pdf"),
    PHP("php", "php", "application/x-httpd-php"),
    PPT("ppt", "Microsoft PowerPoint", "application/vnd.ms-powerpoint"),
    PPTX("pptx", "Microsoft PowerPoint\uff08OpenXML\uff09", "application/vnd.openxmlformats-officedocument.presentationml.presentation"),
    RAR("rar", "RAR\u6863\u6848", "application/vnd.rar"),
    RTF("rtf", "\u5bcc\u6587\u672c\u683c\u5f0f", "application/rtf"),
    SH("sh", "Bourne Shell\u811a\u672c", "application/x-sh"),
    SVG("svg", "\u53ef\u7f29\u653e\u77e2\u91cf\u56fe\u5f62\uff08SVG\uff09", "image/svg+xml"),
    SWF("swf", "\u5c0f\u578bWeb\u683c\u5f0f\uff08SWF\uff09\u6216Adobe Flash\u6587\u6863", "application/x-shockwave-flash"),
    TAR("tar", "\u78c1\u5e26\u5b58\u6863\uff08TAR\uff09", "application/x-tar"),
    TIF("tif", "\u6807\u8bb0\u56fe\u50cf\u6587\u4ef6\u683c\u5f0f\uff08TIFF\uff09", "image/tiff"),
    TIFF("tiff", "\u6807\u8bb0\u56fe\u50cf\u6587\u4ef6\u683c\u5f0f\uff08TIFF\uff09", "image/tiff"),
    TS("ts", "MPEG\u4f20\u8f93\u6d41", "video/mp2t"),
    TTF("ttf", "ttf\u5b57\u4f53", "font/ttf"),
    TXT("txt", "\u6587\u672c\uff08\u901a\u5e38\u4e3aASCII\u6216ISO 8859- n", "text/plain"),
    VSD("vsd", "\u5fae\u8f6fVisio", "application/vnd.visio"),
    WAV("wav", "\u6ce2\u5f62\u97f3\u9891\u683c\u5f0f", "audio/wav"),
    WEBA("weba", "WEBM\u97f3\u9891", "audio/webm"),
    WEBM("webm", "WEBM\u89c6\u9891", "video/webm"),
    WEBP("webp", "WEBP\u56fe\u50cf", "image/webp"),
    WOFF("woff", "Web\u5f00\u653e\u5b57\u4f53\u683c\u5f0f\uff08WOFF\uff09", "font/woff"),
    WOFF2("woff2", "Web\u5f00\u653e\u5b57\u4f53\u683c\u5f0f\uff08WOFF\uff09", "font/woff2"),
    XHTML("xhtml", "XHTML", "application/xhtml+xml"),
    XLS("xls", "\u5fae\u8f6fExcel", "application/vnd.ms-excel"),
    XLSX("xlsx", "\u5fae\u8f6fExcel\uff08OpenXML\uff09", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    XML("xml", "XML", "application/xml"),
    XUL("xul", "XUL", "application/vnd.mozilla.xul+xml"),
    ZIP("zip", "ZIP", "application/zip"),
    MIME_3GP("3gp", "3GPP audio/video container", "video/3gpp"),
    MIME_3GP_WITHOUT_VIDEO("3gp", "3GPP audio/video container doesn't contain video", "audio/3gpp2"),
    MIME_3G2("3g2", "3GPP2 audio/video container", "video/3gpp2"),
    MIME_3G2_WITHOUT_VIDEO("3g2", "3GPP2 audio/video container  doesn't contain video", "audio/3gpp2"),
    MIME_7Z("7z", "7-zip\u5b58\u6863", "application/x-7z-compressed");

    private static Map<String, MimeTypeEnum> EXT_ENUM_MAP;
    private static Map<String, MimeTypeEnum> CONTENT_TYPE_ENUMM_MAP;
    private final String extension;
    private final String explain;
    private final String mimeType;

    private MimeTypeEnum(String extension, String explain, String mimeType) {
        this.extension = extension;
        this.explain = explain;
        this.mimeType = mimeType;
    }

    public static MimeTypeEnum getByExtension(String extension) {
        if (null == extension) {
            return null;
        }
        String lowExt = extension.toLowerCase(Locale.ROOT);
        return EXT_ENUM_MAP.get(lowExt);
    }

    public static MimeTypeEnum getByContentType(String contentType) {
        if (null == contentType) {
            return null;
        }
        String lowContentType = contentType.toLowerCase(Locale.ROOT);
        return CONTENT_TYPE_ENUMM_MAP.get(lowContentType);
    }

    public static String getContentType(String fileType) {
        MimeTypeEnum mimeTypeEnum = MimeTypeEnum.getByExtension(fileType);
        if (mimeTypeEnum != null) {
            return mimeTypeEnum.getMimeType();
        }
        return "application/octet-stream";
    }

    public static String getFileExtension(String contentType) {
        MimeTypeEnum mimeTypeEnum = MimeTypeEnum.getByContentType(contentType);
        if (mimeTypeEnum != null) {
            return mimeTypeEnum.getExtension();
        }
        return "";
    }

    public String getExtension() {
        return this.extension;
    }

    public String getExplain() {
        return this.explain;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    static {
        EXT_ENUM_MAP = new HashMap<String, MimeTypeEnum>();
        CONTENT_TYPE_ENUMM_MAP = new HashMap<String, MimeTypeEnum>();
        for (MimeTypeEnum typeEnum : MimeTypeEnum.values()) {
            EXT_ENUM_MAP.put(typeEnum.getExtension(), typeEnum);
            CONTENT_TYPE_ENUMM_MAP.put(typeEnum.getMimeType(), typeEnum);
        }
    }
}

