/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.exception;

import com.dss.sdk.utils.string.StrUtil;

public class ApiException
extends Exception {
    private String errCode;
    private String errMsg;

    public ApiException() {
    }

    public ApiException(String message, Throwable cause) {
        super(message, cause);
        this.errMsg = message;
    }

    public ApiException(String errCode, String errMsg) {
        super(errCode + ":" + errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public ApiException(String message) {
        super(message);
        this.errMsg = message;
    }

    public ApiException(Throwable cause) {
        super(cause);
        this.errMsg = StrUtil.blankToDefault(cause.getMessage(), cause.getLocalizedMessage());
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

