/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.file;

import com.dss.sdk.exception.ApiException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileItem {
    private static final Logger log = LoggerFactory.getLogger(FileItem.class);
    private DssFile dssFile;

    public FileItem(File file) {
        this.dssFile = new LocalContract(file);
    }

    public FileItem(String filePath) {
        this(new File(filePath));
    }

    public FileItem(String fileName, byte[] content) {
        this(fileName, content, null);
    }

    public FileItem(String fileName, byte[] content, String mimeType) {
        this.dssFile = new ByteArrayContract(fileName, content, mimeType);
    }

    public FileItem(String fileName, InputStream stream) {
        this(fileName, stream, null);
    }

    public FileItem(String fileName, InputStream stream, String mimeType) {
        this.dssFile = new StreamContract(fileName, stream, mimeType);
    }

    public boolean isValid() {
        return this.dssFile.isValid();
    }

    public String getFileName() {
        return this.dssFile.getFileName();
    }

    public String getMimeType() throws IOException {
        return this.dssFile.getMimeType();
    }

    public long getFileLength() {
        return this.dssFile.getFileLength();
    }

    public void write(OutputStream output) throws IOException {
        this.dssFile.write(output);
    }

    public byte[] getFile() throws ApiException {
        return this.dssFile.getFile();
    }

    private static class StreamContract
    implements DssFile {
        private String fileName;
        private InputStream stream;
        private String mimeType;

        public StreamContract(String fileName, InputStream stream, String mimeType) {
            this.fileName = fileName;
            this.stream = stream;
            this.mimeType = mimeType;
        }

        @Override
        public boolean isValid() {
            return this.stream != null && this.fileName != null;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getMimeType() {
            if (this.mimeType == null) {
                return "application/octet-stream";
            }
            return this.mimeType;
        }

        @Override
        public long getFileLength() {
            return 0L;
        }

        @Override
        public byte[] getFile() throws ApiException {
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] b = new byte[4096];
                while ((n = this.stream.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                bos.close();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                log.error("Read FileItem Exception", (Throwable)e);
                throw new ApiException(e);
            }
            finally {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (Throwable e) {
                        log.error("Close Read FileItem Throwable", e);
                        throw new ApiException(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream output) throws IOException {
            try {
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = this.stream.read(buffer))) {
                    output.write(buffer, 0, n);
                }
            }
            finally {
                if (this.stream != null) {
                    this.stream.close();
                }
            }
        }
    }

    private static class ByteArrayContract
    implements DssFile {
        private String fileName;
        private byte[] content;
        private String mimeType;

        public ByteArrayContract(String fileName, byte[] content, String mimeType) {
            this.fileName = fileName;
            this.content = content;
            this.mimeType = mimeType;
        }

        @Override
        public boolean isValid() {
            return this.content != null && this.fileName != null;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getMimeType() {
            if (this.mimeType == null) {
                return "application/octet-stream";
            }
            return this.mimeType;
        }

        @Override
        public long getFileLength() {
            return this.content.length;
        }

        @Override
        public byte[] getFile() throws ApiException {
            return this.content;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            output.write(this.content);
        }
    }

    private static class LocalContract
    implements DssFile {
        private File file;

        public LocalContract(File file) {
            this.file = file;
        }

        @Override
        public boolean isValid() {
            return this.file != null && this.file.exists() && this.file.isFile();
        }

        @Override
        public String getFileName() {
            return this.file.getName();
        }

        @Override
        public String getMimeType() {
            return "application/octet-stream";
        }

        @Override
        public long getFileLength() {
            return this.file.length();
        }

        @Override
        public byte[] getFile() throws ApiException {
            if (this.getFileLength() == 0L) {
                return new byte[0];
            }
            FileInputStream inputStream = null;
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                inputStream = new FileInputStream(this.file);
                byte[] b = new byte[(int)this.file.length()];
                while ((n = inputStream.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                bos.close();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                log.error("Read FileItem Exception", (Throwable)e);
                throw new ApiException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable e) {
                        log.error("Close Read FileItem Throwable", e);
                        throw new ApiException(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream output) throws IOException {
            try (FileInputStream input = null;){
                input = new FileInputStream(this.file);
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = ((InputStream)input).read(buffer))) {
                    output.write(buffer, 0, n);
                }
            }
        }
    }

    private static interface DssFile {
        public boolean isValid();

        public String getFileName();

        public String getMimeType();

        public long getFileLength();

        public byte[] getFile() throws ApiException;

        public void write(OutputStream var1) throws IOException;
    }
}

