/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.utils.crypt;

import com.dss.sdk.enums.SignDataEnum;
import com.dss.sdk.enums.SignTypeEnum;
import com.dss.sdk.utils.crypt.HexUtil;
import com.dss.sdk.utils.date.DateUtil;
import com.dss.sdk.utils.json.GsonUtil;
import com.dss.sdk.utils.random.RandomUtil;
import com.dss.sdk.utils.string.StrUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSCryptUtil {
    private static final Logger log = LoggerFactory.getLogger(DSSCryptUtil.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private DSSCryptUtil() {
    }

    public static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(UTF8));
    }

    public static byte[] hmacSM3(byte[] key, String msg) {
        HMac mac = new HMac((Digest)new SM3Digest());
        KeyParameter keyParameter = new KeyParameter(key);
        mac.init((CipherParameters)keyParameter);
        mac.update(msg.getBytes(UTF8), 0, msg.length());
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static String sha256Hex(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] d = md.digest(s.getBytes(UTF8));
        return HexUtil.printHexBinary(d).toLowerCase();
    }

    public static String sign(String sortParam, String signType, String timestamp, String appSecret) {
        String sign = "";
        try {
            String signText = DSSCryptUtil.sha256Hex(sortParam);
            SignTypeEnum signEnum = SignTypeEnum.getAlgEnum(signType);
            switch (signEnum) {
                case SM3: {
                    byte[] secretSigning = DSSCryptUtil.hmacSM3(appSecret.getBytes(UTF8), timestamp);
                    sign = HexUtil.printHexBinary(DSSCryptUtil.hmacSM3(secretSigning, signText)).toLowerCase();
                    break;
                }
                case SHA256: {
                    byte[] secretSigning = DSSCryptUtil.hmac256(appSecret.getBytes(UTF8), timestamp);
                    sign = HexUtil.printHexBinary(DSSCryptUtil.hmac256(secretSigning, signText)).toLowerCase();
                }
            }
        }
        catch (Throwable e) {
            log.error("\u7b7e\u540d\u8ba1\u7b97\u5f02\u5e38", e);
        }
        return sign;
    }

    public static String sortParameters(Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return null;
        }
        ArrayList<String> removeKeys = new ArrayList<String>(){
            {
                this.add(SignDataEnum.LANGUAGE.getName());
            }
        };
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!StrUtil.isBlank(entry.getValue())) continue;
            removeKeys.add(entry.getKey());
        }
        for (String key : removeKeys) {
            parameters.remove(key);
        }
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, String> paramMap = new TreeMap<String, String>(parameters);
        int index = 0;
        for (Map.Entry entry : paramMap.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            if (++index == parameters.size()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    public static HashMap<String, String> getHeaderMap(String appId, String signType, String language) {
        HashMap<String, String> reqHeader = new HashMap<String, String>(8);
        reqHeader.put(SignDataEnum.APPID.getName(), appId);
        reqHeader.put(SignDataEnum.SIGNTYPE.getName(), signType);
        reqHeader.put(SignDataEnum.LANGUAGE.getName(), language);
        reqHeader.put(SignDataEnum.TIMESTAMP.getName(), String.valueOf(DateUtil.current()));
        reqHeader.put(SignDataEnum.NONCE.getName(), RandomUtil.randomString(32));
        return reqHeader;
    }

    public static HashMap<String, String> getHeaderMap(String appId, String language) {
        return DSSCryptUtil.getHeaderMap(appId, SignTypeEnum.SHA256.getValue(), language);
    }

    public static void getFormSign(Map<String, String> reqHeader, Map<String, String> params, String appKey) {
        if (params == null) {
            params = new HashMap<String, String>(8);
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>(params);
        String bizContent = GsonUtil.toJsonStr(sortMap);
        DSSCryptUtil.getSign(reqHeader, bizContent, appKey);
    }

    public static void getSign(Map<String, String> reqHeader, String json, String appKey) {
        DSSCryptUtil.signature(reqHeader, json, appKey);
    }

    private static void signature(Map<String, String> reqHeader, String biz, String appKey) {
        reqHeader.put(SignDataEnum.BIZCONTENT.getName(), biz);
        String paramToSignStr = DSSCryptUtil.sortParameters(reqHeader);
        String signature = DSSCryptUtil.sign(paramToSignStr, reqHeader.get(SignDataEnum.SIGNTYPE.getName()), reqHeader.get(SignDataEnum.TIMESTAMP.getName()), appKey);
        reqHeader.put(SignDataEnum.SIGN.getName(), signature);
        reqHeader.remove(SignDataEnum.BIZCONTENT.getName());
    }
}

