/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.utils.http;

import com.dss.sdk.config.HttpConfig;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;
import com.dss.sdk.utils.http.RequestParametersHolder;
import com.dss.sdk.utils.http.TrustAllTrustManager;
import com.dss.sdk.utils.string.StrUtil;
import com.dss.shaded.client5.http.classic.methods.HttpGet;
import com.dss.shaded.client5.http.classic.methods.HttpPost;
import com.dss.shaded.client5.http.classic.methods.HttpUriRequest;
import com.dss.shaded.client5.http.config.RequestConfig;
import com.dss.shaded.client5.http.entity.mime.HttpMultipartMode;
import com.dss.shaded.client5.http.entity.mime.MultipartEntityBuilder;
import com.dss.shaded.client5.http.impl.classic.CloseableHttpClient;
import com.dss.shaded.client5.http.impl.classic.CloseableHttpResponse;
import com.dss.shaded.client5.http.impl.classic.HttpClients;
import com.dss.shaded.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.dss.shaded.client5.http.socket.ConnectionSocketFactory;
import com.dss.shaded.client5.http.socket.PlainConnectionSocketFactory;
import com.dss.shaded.client5.http.ssl.HttpsSupport;
import com.dss.shaded.client5.http.ssl.SSLConnectionSocketFactory;
import com.dss.shaded.core5.http.ContentType;
import com.dss.shaded.core5.http.Header;
import com.dss.shaded.core5.http.HttpEntity;
import com.dss.shaded.core5.http.HttpHost;
import com.dss.shaded.core5.http.HttpResponse;
import com.dss.shaded.core5.http.config.RegistryBuilder;
import com.dss.shaded.core5.http.io.entity.EntityUtils;
import com.dss.shaded.core5.http.io.entity.StringEntity;
import com.dss.shaded.core5.util.Timeout;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    public static HttpConfig httpConfig;
    private static int DEFAULT_MAX_PER_ROUTE;
    private static int DEFAULT_SOCKET_MAX_TOTAL;
    private static volatile CloseableHttpClient closeableHttpClient;
    private static Lock lock;

    private HttpUtil() {
    }

    public static DssResponse post(String url, Map<String, String> reqHeader, Object params, Map<String, FileItem> files, RequestParametersHolder requestHolder) throws ApiException {
        try {
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
            HttpPost httpPost = HttpUtil.getHttpPost(url, params, files, "UTF-8");
            httpPost.setConfig(HttpUtil.getRequestConfig(httpConfig));
            return HttpUtil.executeHttpRequest(httpClient, httpPost, reqHeader, requestHolder);
        }
        catch (Exception e) {
            log.error("url=[{}] http\u8bf7\u6c42\u5931\u8d25\uff1a{}", new Object[]{url, e.getMessage(), e});
            throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public static DssResponse get(String url, Map<String, String> reqHeader, Map<String, String> params, RequestParametersHolder requestHolder) throws ApiException {
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
        HttpGet httpGet = HttpUtil.getHttpGet(url, params, "UTF-8");
        httpGet.setConfig(HttpUtil.getRequestConfig(httpConfig));
        return HttpUtil.executeHttpRequest(httpClient, httpGet, reqHeader, requestHolder);
    }

    public static DssEntityResponse downLoadFiles(String url, Map<String, String> reqHeader, String params) throws Exception {
        DssEntityResponse entity = new DssEntityResponse();
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
        try {
            HttpPost httpPost = HttpUtil.getHttpPost(url, params, null, "UTF-8");
            if (reqHeader != null) {
                for (Map.Entry<String, String> entry : reqHeader.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setConfig(HttpUtil.getRequestConfig(httpConfig));
            response = httpClient.execute(httpPost);
            HttpUtil.reqesutAndResponseLog(httpPost, response);
            entity.setHttpStatusCode(response.getCode());
            HttpEntity respEntity = response.getEntity();
            String contentType = respEntity.getContentType();
            if (contentType != null && contentType.contains(ContentType.APPLICATION_JSON.getMimeType())) {
                entity.setData(EntityUtils.toString(respEntity));
            } else {
                byte[] bytes = EntityUtils.toByteArray(response.getEntity());
                entity.setContent(bytes);
                entity.setContentType(contentType);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("CloseableHttpResponse\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return entity;
    }

    private static HttpGet getHttpGet(String url, Map<String, String> params, String encode) {
        StringBuilder buf = new StringBuilder(url);
        if (params != null) {
            String flag = url.indexOf(63) == -1 ? "?" : "&";
            for (Map.Entry<String, String> entry : params.entrySet()) {
                buf.append(flag);
                buf.append(entry.getKey());
                buf.append("=");
                try {
                    String param = entry.getValue();
                    if (param == null) {
                        param = "";
                    }
                    buf.append(URLEncoder.encode(param, encode));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("URLEncoder Error,encode=" + encode + ",param=" + entry.getValue(), (Throwable)e);
                }
                flag = "&";
            }
        }
        return new HttpGet(buf.toString());
    }

    private static HttpPost getPost(String url, Map<String, String> params, Map<String, FileItem> files) throws ApiException {
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (files != null && !files.isEmpty()) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                FileItem fileItem = (FileItem)entry.getValue();
                if (!fileItem.isValid()) {
                    log.error("FileItem is invalid");
                    throw new ApiException("FileItem is invalid");
                }
                try {
                    multipartEntityBuilder.addBinaryBody(entry.getKey(), fileItem.getFile(), ContentType.create(fileItem.getMimeType()), fileItem.getFileName());
                }
                catch (IOException e) {
                    log.error("FileItem ContentType is invalid");
                    throw new ApiException("FileItem ContentType is invalid ");
                }
            }
        }
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                multipartEntityBuilder.addTextBody(key, value, ContentType.TEXT_PLAIN.withCharset("UTF-8"));
            }
            multipartEntityBuilder.setMode(HttpMultipartMode.EXTENDED);
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        return httpPost;
    }

    private static HttpPost getHttpPost(String url, Object params, Map<String, FileItem> files, String charset) throws ApiException {
        HttpPost httpPost = new HttpPost(url);
        if (params instanceof String) {
            if (StrUtil.isNotBlank((String)params)) {
                StringEntity httpEntity = new StringEntity((String)params, ContentType.APPLICATION_JSON.withCharset(charset));
                httpPost.setEntity(httpEntity);
            }
        } else {
            httpPost = HttpUtil.getPost(url, (Map)params, files);
        }
        return httpPost;
    }

    public static CloseableHttpClient getHttpClient(HttpConfig httpConfig) throws ApiException {
        if (closeableHttpClient != null) {
            return closeableHttpClient;
        }
        lock.lock();
        try {
            if (closeableHttpClient != null) {
                CloseableHttpClient closeableHttpClient = HttpUtil.closeableHttpClient;
                return closeableHttpClient;
            }
            RegistryBuilder<ConnectionSocketFactory> builder = RegistryBuilder.create();
            builder.register("http", PlainConnectionSocketFactory.getSocketFactory());
            if (httpConfig != null && Boolean.TRUE.equals(httpConfig.getProxyFlag())) {
                builder.register("https", SSLConnectionSocketFactory.getSocketFactory());
            } else {
                SSLContext sslContext;
                Boolean ignoreSSLCheck = httpConfig != null && httpConfig.getIgnoreSSLCheck() != false;
                Boolean ignoreHostCheck = httpConfig != null && httpConfig.getIgnoreHostCheck() != false;
                HostnameVerifier hostnameVerifier = HttpsSupport.getDefaultHostnameVerifier();
                try {
                    TrustManager[] trustManagerArray;
                    sslContext = SSLContext.getInstance("TLSv1.2");
                    if (ignoreSSLCheck.booleanValue()) {
                        TrustManager[] trustManagerArray2 = new TrustManager[1];
                        trustManagerArray = trustManagerArray2;
                        trustManagerArray2[0] = new TrustAllTrustManager();
                    } else {
                        trustManagerArray = null;
                    }
                    sslContext.init(null, trustManagerArray, new SecureRandom());
                    hostnameVerifier = (hostname, session) -> true;
                }
                catch (Exception e) {
                    log.error("Failed to initialize SSL context", (Throwable)e);
                    sslContext = SSLContext.getInstance("TLSv1.2");
                }
                if (ignoreHostCheck.booleanValue()) {
                    hostnameVerifier = (hostname, session) -> true;
                }
                builder.register("https", new SSLConnectionSocketFactory(sslContext, hostnameVerifier));
            }
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(builder.build());
            Integer defaultMaxPerRoute = DEFAULT_MAX_PER_ROUTE;
            Integer defaultSocketMaxTotal = DEFAULT_SOCKET_MAX_TOTAL;
            if (httpConfig != null && httpConfig.getDefaultMaxPerRoute() != null && httpConfig.getDefaultMaxPerRoute() > 0) {
                defaultMaxPerRoute = httpConfig.getDefaultMaxPerRoute();
            }
            if (httpConfig != null && httpConfig.getDefaultSocketMaxTotal() != null && httpConfig.getDefaultSocketMaxTotal() > 0) {
                defaultSocketMaxTotal = httpConfig.getDefaultSocketMaxTotal();
            }
            connectionManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
            connectionManager.setMaxTotal(defaultSocketMaxTotal);
            connectionManager.setValidateAfterInactivity(Timeout.of(3000L, TimeUnit.MILLISECONDS));
            connectionManager.closeExpired();
            closeableHttpClient = HttpClients.custom().setConnectionManager(connectionManager).build();
        }
        catch (Exception e) {
            log.error("HttpClient\u751f\u6210\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("HttpClient\u751f\u6210\u5931\u8d25");
        }
        finally {
            lock.unlock();
        }
        return closeableHttpClient;
    }

    public static DssResponse executeHttpRequest(CloseableHttpClient client, HttpUriRequest request, Map<String, String> reqHeader, RequestParametersHolder requestHolder) throws ApiException {
        CloseableHttpResponse response = null;
        try {
            if (reqHeader != null && !reqHeader.isEmpty()) {
                for (Map.Entry<String, String> entry : reqHeader.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            response = client.execute(request);
            HttpUtil.reqesutAndResponseLog(request, response);
            DssResponse httpInfoRes = DssResponse.getInstance();
            requestHolder.setHttpStatusCode(response.getCode());
            if (response.getEntity() != null) {
                requestHolder.setResponseBody(EntityUtils.toString(response.getEntity(), "UTF-8"));
            }
            if (log.isDebugEnabled()) {
                log.debug("Http status code {}", (Object)response.getCode());
            }
            DssResponse dssResponse = httpInfoRes;
            return dssResponse;
        }
        catch (SocketTimeoutException eto) {
            log.error("\u8bf7\u6c42\u94fe\u63a5\u8d85\u65f6\uff1a{}", (Object)eto.getMessage(), (Object)eto);
            throw new ApiException("\u8bf7\u6c42\u8d85\u65f6");
        }
        catch (Exception e) {
            log.error("executeHttpRequest\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("CloseableHttpResponse\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private static void reqesutAndResponseLog(HttpUriRequest request, HttpResponse response) throws URISyntaxException {
        Header[] requestHeaders;
        URI uri = request.getUri();
        if (uri != null && log.isDebugEnabled()) {
            log.debug("request url = [{}]", (Object)uri);
        }
        if ((requestHeaders = request.getHeaders()) != null && requestHeaders.length > 0 && log.isDebugEnabled()) {
            log.debug("request headers {}", Arrays.stream(requestHeaders).collect(Collectors.toList()));
        }
    }

    private static RequestConfig getRequestConfig(HttpConfig httpConfig) {
        RequestConfig.Builder custom = RequestConfig.custom();
        if (httpConfig != null) {
            if (httpConfig.getReadTimeout() != null) {
                custom.setResponseTimeout(httpConfig.getReadTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
            if (httpConfig.getConnectTimeout() != null) {
                custom.setConnectionRequestTimeout(httpConfig.getConnectTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
            if (Boolean.TRUE.equals(httpConfig.getProxyFlag())) {
                HttpHost proxy = new HttpHost("http", httpConfig.getProxyHost(), (int)httpConfig.getProxyPort());
                custom.setProxy(proxy);
            }
        }
        return custom.build();
    }

    static {
        DEFAULT_MAX_PER_ROUTE = 350;
        DEFAULT_SOCKET_MAX_TOTAL = 400;
        lock = new ReentrantLock();
    }
}

