/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.utils.json;

import com.dss.sdk.utils.json.IntOrLongOrDoubleStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtil {
    private static final Logger log = LoggerFactory.getLogger(GsonUtil.class);
    private static final Gson gson;

    private GsonUtil() {
    }

    public static Gson getGson() {
        return gson;
    }

    public static String toJSONString(Object object) {
        return gson.toJson(object);
    }

    public static String toJsonStr(Object object) {
        return GsonUtil.toJSONString(object);
    }

    public static <T> T fromJson(String gsonString, Class<T> cls) {
        return (T)gson.fromJson(gsonString, cls);
    }

    public static <T> T fromJson(JsonObject jsonObject, Class<T> cls) {
        return (T)gson.fromJson((JsonElement)jsonObject, cls);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return (T)gson.fromJson(json, typeOfT);
    }

    public static <T> T toBean(String jsonStr, ParameterizedType parameterizedType) {
        if (jsonStr == null) {
            return null;
        }
        return (T)gson.fromJson(jsonStr, (Type)parameterizedType);
    }

    public static <T> T toBean(String jsonStr, Class<T> cls) {
        return GsonUtil.fromJson(jsonStr, cls);
    }

    public static JsonObject beanToJsonObj(Object bean) {
        return gson.toJsonTree(bean).getAsJsonObject();
    }

    public static <T> List<T> toList(String json, Class<T> cls) {
        return (List)gson.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{cls}).getType());
    }

    public static Map<String, Object> toMap(String gsonString) {
        return GsonUtil.toMap(gsonString, String.class, Object.class);
    }

    public static <V> Map<String, V> toMap(String gsonString, Class<V> valueCls) {
        return GsonUtil.toMap(gsonString, String.class, valueCls);
    }

    public static <K, V> Map<K, V> toMap(String gsonString, Class<K> keyCls, Class<V> valueCls) {
        return (Map)gson.fromJson(gsonString, TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyCls, valueCls}).getType());
    }

    static {
        String dataFormat = "yyyy-MM-dd HH:mm:ss";
        IntOrLongOrDoubleStrategy intOrLongOrDoubleStrategy = new IntOrLongOrDoubleStrategy();
        gson = new GsonBuilder().disableHtmlEscaping().setNumberToNumberStrategy((ToNumberStrategy)intOrLongOrDoubleStrategy).setObjectToNumberStrategy((ToNumberStrategy)intOrLongOrDoubleStrategy).setDateFormat(dataFormat).create();
    }
}

