/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.utils.string;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class StrUtil {
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    public static final String COLON = ":";
    public static final String DASHED = "-";
    public static final String SLASH = "/";

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StrUtil.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StrUtil.isBlank(cs);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StrUtil.trim(str);
        return StrUtil.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return StrUtil.isBlank(str) ? defaultStr : str.toString();
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String fastSimpleUUID() {
        return UUID.randomUUID().toString().replaceAll(DASHED, EMPTY);
    }
}

