/*
 * Decompiled with CFR 0.152.
 */
package com.dss.sdk.utils.url;

import com.dss.sdk.utils.string.StrUtil;
import java.util.HashMap;

public abstract class DssUrlUtils {
    public static String getServerUrl(String serverUrl, String apiMethodName, String session, HashMap appParams) {
        if (((String)apiMethodName).indexOf("/") > 0) {
            apiMethodName = "/" + (String)apiMethodName;
        }
        String host = serverUrl.lastIndexOf("/") == 0 ? DssUrlUtils.replaceLast(serverUrl, "/", "") : serverUrl;
        return host + (String)apiMethodName;
    }

    public static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (StrUtil.isEmpty(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    private static String replaceLast(String text, String strToReplace, String replaceWithThis) {
        return text.replaceFirst("(?s)" + strToReplace + "(?!.*?" + strToReplace + ")", replaceWithThis);
    }
}

